/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LighterAST;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.SubstitutedFileType;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentImpl
extends UserDataHolderBase
implements FileContent {
    private final VirtualFile myFile;
    private final String myFileName;
    private final FileType myFileType;
    private Charset myCharset;
    private byte[] myContent;
    private CharSequence myContentAsText;
    private final long myStamp;
    private byte[] myHash;
    private boolean myLighterASTShouldBeThreadSafe;
    private final boolean myPhysicalContent;
    private static final Key<PsiFile> CACHED_PSI = Key.create((String)"cached psi from content");

    public FileContentImpl(@NotNull VirtualFile file2, @NotNull CharSequence contentAsText, long documentStamp) {
        this(file2, contentAsText, null, documentStamp, false);
    }

    public FileContentImpl(@NotNull VirtualFile file2, @NotNull byte[] content) {
        this(file2, null, content, -1L, true);
    }

    FileContentImpl(@NotNull VirtualFile file2) {
        this(file2, null, null, -1L, true);
    }

    private FileContentImpl(@NotNull VirtualFile file2, CharSequence contentAsText, byte[] content, long stamp, boolean physicalContent) {
        this.myFile = file2;
        this.myContentAsText = contentAsText;
        this.myContent = content;
        this.myFileType = file2.getFileType();
        this.myFileName = file2.getName();
        this.myStamp = stamp;
        this.myPhysicalContent = physicalContent;
    }

    public Project getProject() {
        return (Project)this.getUserData(IndexingDataKeys.PROJECT);
    }

    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psi = (PsiFile)this.getUserData(IndexingDataKeys.PSI_FILE);
        if (psi == null) {
            psi = (PsiFile)this.getUserData(CACHED_PSI);
        }
        if (psi == null) {
            psi = this.createFileFromText(this.getContentAsText());
            psi.putUserData(IndexingDataKeys.VIRTUAL_FILE, (Object)this.getFile());
            this.putUserData(CACHED_PSI, psi);
        }
        return psi;
    }

    @NotNull
    public LighterAST getLighterASTForPsiDependentIndex() {
        LighterAST lighterAST = (LighterAST)this.getUserData(IndexingDataKeys.LIGHTER_AST_NODE_KEY);
        if (lighterAST == null) {
            FileASTNode node = this.getPsiFileForPsiDependentIndex().getNode();
            lighterAST = this.myLighterASTShouldBeThreadSafe ? new TreeBackedLighterAST(node) : node.getLighterAST();
            this.putUserData(IndexingDataKeys.LIGHTER_AST_NODE_KEY, lighterAST);
        }
        return lighterAST;
    }

    void ensureThreadSafeLighterAST() {
        this.myLighterASTShouldBeThreadSafe = true;
    }

    public PsiFile createFileFromText(@NotNull CharSequence text) {
        Project project = this.getProject();
        if (project == null) {
            project = DefaultProjectFactory.getInstance().getDefaultProject();
        }
        return FileContentImpl.createFileFromText(project, text, (LanguageFileType)this.getFileTypeWithoutSubstitution(), this.myFile, this.myFileName);
    }

    @NotNull
    public static PsiFile createFileFromText(@NotNull Project project, @NotNull CharSequence text, @NotNull LanguageFileType fileType, @NotNull VirtualFile file2, @NotNull String fileName2) {
        Language language = fileType.getLanguage();
        Language substitutedLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(language, file2, project);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(fileName2, substitutedLanguage, text, false, false, false, file2);
        if (psiFile == null) {
            throw new IllegalStateException("psiFile is null. language = " + language.getID() + ", substitutedLanguage = " + substitutedLanguage.getID());
        }
        return psiFile;
    }

    @NotNull
    private FileType getSubstitutedFileType() {
        return SubstitutedFileType.substituteFileType(this.myFile, this.myFileType, this.getProject());
    }

    public static FileContent createByFile(@NotNull VirtualFile file2) {
        try {
            return new FileContentImpl(file2, file2.contentsToByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private FileType getFileTypeWithoutSubstitution() {
        return this.myFileType;
    }

    @NotNull
    public FileType getFileType() {
        return this.getSubstitutedFileType();
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public String getFileName() {
        return this.myFileName;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            this.myCharset = charset = this.myFile.getCharset();
        }
        return charset;
    }

    public long getStamp() {
        return this.myStamp;
    }

    @NotNull
    public byte[] getContent() {
        byte[] content = this.myContent;
        if (content == null) {
            this.myContent = content = this.myContentAsText.toString().getBytes(this.getCharset());
        }
        return content;
    }

    @NotNull
    public CharSequence getContentAsText() {
        if (this.myFileType.isBinary()) {
            throw new IllegalDataException("Cannot obtain text for binary file type : " + this.myFileType.getDescription());
        }
        CharSequence content = (CharSequence)this.getUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY);
        if (content != null) {
            return content;
        }
        CharSequence contentAsText = this.myContentAsText;
        if (contentAsText == null) {
            this.myContentAsText = contentAsText = LoadTextUtil.getTextByBinaryPresentation(this.myContent, this.myFile);
            this.myContent = null;
        }
        return contentAsText;
    }

    public String toString() {
        return this.myFileName;
    }

    @Nullable
    public byte[] getHash() {
        return this.myHash;
    }

    public void setHash(byte[] hash) {
        this.myHash = hash;
    }

    @NotNull
    public PsiFile getPsiFileForPsiDependentIndex() {
        PsiFile existingPsi;
        PsiDocumentManager psiDocumentManager;
        Document document;
        PsiFile psi = null;
        if (!this.myPhysicalContent && (document = FileDocumentManager.getInstance().getCachedDocument(this.getFile())) != null && (psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject())).isUncommited(document) && (existingPsi = psiDocumentManager.getPsiFile(document)) != null) {
            psi = existingPsi;
        }
        if (psi == null) {
            psi = this.getPsiFile();
        }
        return psi;
    }

    public static class IllegalDataException
    extends RuntimeException {
        IllegalDataException(String message) {
            super(message);
        }
    }
}

