/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.HiddenFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.indexing.IdFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindSymbolParameters {
    private final String myCompletePattern;
    private final String myLocalPatternName;
    private final GlobalSearchScope mySearchScope;
    private final IdFilter myIdFilter;

    public FindSymbolParameters(@NotNull String pattern, @NotNull String name, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        this.myCompletePattern = pattern;
        this.myLocalPatternName = name;
        this.mySearchScope = scope;
        this.myIdFilter = idFilter;
    }

    public String getCompletePattern() {
        return this.myCompletePattern;
    }

    public String getLocalPatternName() {
        return this.myLocalPatternName;
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        return this.mySearchScope;
    }

    @Nullable
    public IdFilter getIdFilter() {
        return this.myIdFilter;
    }

    public static FindSymbolParameters wrap(@NotNull String pattern, @NotNull Project project, boolean searchInLibraries) {
        return new FindSymbolParameters(pattern, pattern, FindSymbolParameters.searchScopeFor(project, searchInLibraries), null);
    }

    public static GlobalSearchScope searchScopeFor(@Nullable Project project, boolean searchInLibraries) {
        EverythingGlobalScope baseScope = project == null ? new EverythingGlobalScope() : (searchInLibraries ? ProjectScope.getAllScope((Project)project) : ProjectScope.getProjectScope((Project)project));
        return baseScope.intersectWith((GlobalSearchScope)new EverythingGlobalScope(project){

            public boolean contains(@NotNull VirtualFile file2) {
                return !(file2.getFileSystem() instanceof HiddenFileSystem);
            }
        });
    }

    public Project getProject() {
        return this.mySearchScope.getProject();
    }

    public boolean isSearchInLibraries() {
        return this.mySearchScope.isSearchInLibraries();
    }
}

