/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.indexing.FileBasedIndexImpl;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndexedFilesListener
implements BulkFileListener {
    private final ManagingFS myManagingFS = ManagingFS.getInstance();
    @Nullable
    private final String myConfigPath = IndexedFilesListener.calcConfigPath(PathManager.getConfigPath());
    @Nullable
    private final String myLogPath = IndexedFilesListener.calcConfigPath(PathManager.getLogPath());

    protected void buildIndicesForFileRecursively(@NotNull VirtualFile file2, boolean contentChange) {
        if (file2.isDirectory()) {
            ContentIterator iterator = fileOrDir -> {
                this.buildIndicesForFile(fileOrDir, contentChange);
                return true;
            };
            this.iterateIndexableFiles(file2, iterator);
        } else {
            this.buildIndicesForFile(file2, contentChange);
        }
    }

    protected boolean invalidateIndicesForFile(@NotNull VirtualFile file2, boolean contentChange) {
        if (this.isUnderConfigOrSystem(file2)) {
            return false;
        }
        if (file2.isDirectory()) {
            this.doInvalidateIndicesForFile(file2, contentChange);
            if (!FileBasedIndexImpl.isMock(file2) && !this.myManagingFS.wereChildrenAccessed(file2)) {
                return false;
            }
        } else {
            this.doInvalidateIndicesForFile(file2, contentChange);
        }
        return true;
    }

    protected abstract void iterateIndexableFiles(@NotNull VirtualFile var1, @NotNull ContentIterator var2);

    protected abstract void buildIndicesForFile(@NotNull VirtualFile var1, boolean var2);

    protected abstract void doInvalidateIndicesForFile(@NotNull VirtualFile var1, boolean var2);

    protected void invalidateIndicesRecursively(@NotNull VirtualFile file2, final boolean contentChange) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                return IndexedFilesListener.this.invalidateIndicesForFile(file2, contentChange);
            }

            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
                return file2 instanceof NewVirtualFile ? ((NewVirtualFile)file2).iterInDbChildren() : null;
            }
        });
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileContentChangeEvent) {
                this.invalidateIndicesRecursively(((VFileContentChangeEvent)vFileEvent).getFile(), true);
                continue;
            }
            if (vFileEvent instanceof VFileDeleteEvent) {
                this.invalidateIndicesRecursively(((VFileDeleteEvent)vFileEvent).getFile(), false);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)vFileEvent;
            String propertyName = pce.getPropertyName();
            if (propertyName.equals("name")) {
                this.invalidateIndicesRecursively(pce.getFile(), false);
                continue;
            }
            if (!propertyName.equals("encoding")) continue;
            this.invalidateIndicesRecursively(pce.getFile(), true);
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent instanceof VFileContentChangeEvent) {
                this.buildIndicesForFileRecursively(((VFileContentChangeEvent)vFileEvent).getFile(), true);
                continue;
            }
            if (vFileEvent instanceof VFileCopyEvent) {
                VFileCopyEvent ce = (VFileCopyEvent)vFileEvent;
                VirtualFile copy = ce.getNewParent().findChild(ce.getNewChildName());
                if (copy == null) continue;
                this.buildIndicesForFileRecursively(copy, false);
                continue;
            }
            if (vFileEvent instanceof VFileCreateEvent) {
                VirtualFile newChild = vFileEvent.getFile();
                if (newChild == null) continue;
                this.buildIndicesForFileRecursively(newChild, false);
                continue;
            }
            if (vFileEvent instanceof VFileMoveEvent) {
                this.buildIndicesForFileRecursively(((VFileMoveEvent)vFileEvent).getFile(), false);
                continue;
            }
            if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
            VFilePropertyChangeEvent pce = (VFilePropertyChangeEvent)vFileEvent;
            String propertyName = pce.getPropertyName();
            if (propertyName.equals("name")) {
                this.buildIndicesForFileRecursively(pce.getFile(), false);
                continue;
            }
            if (!propertyName.equals("encoding")) continue;
            this.buildIndicesForFileRecursively(pce.getFile(), true);
        }
    }

    @Nullable
    private static String calcConfigPath(@NotNull String path) {
        try {
            String _path = FileUtil.toSystemIndependentName((String)new File(path).getCanonicalPath());
            return _path.endsWith("/") ? _path : _path + "/";
        }
        catch (IOException e) {
            FileBasedIndexImpl.LOG.info((Throwable)e);
            return null;
        }
    }

    private boolean isUnderConfigOrSystem(@NotNull VirtualFile file2) {
        String filePath = file2.getPath();
        return this.myConfigPath != null && FileUtil.startsWith((String)filePath, (String)this.myConfigPath) || this.myLogPath != null && FileUtil.startsWith((String)filePath, (String)this.myLogPath);
    }
}

