/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightDirectoryIndex<T> {
    private final Map<VirtualFile, T> myRootInfos = ContainerUtil.newConcurrentMap();
    private final ConcurrentBitSet myNonInterestingIds = new ConcurrentBitSet();
    private final T myDefValue;
    private final Consumer<LightDirectoryIndex<T>> myInitializer;

    public LightDirectoryIndex(@NotNull Disposable parentDisposable, @NotNull T defValue, @NotNull Consumer<LightDirectoryIndex<T>> initializer2) {
        this.myDefValue = defValue;
        this.myInitializer = initializer2;
        this.resetIndex();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(parentDisposable);
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                LightDirectoryIndex.this.resetIndex();
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file2 = vFileEvent.getFile();
                    if (file2 != null && !file2.isDirectory()) continue;
                    LightDirectoryIndex.this.resetIndex();
                    break;
                }
            }
        });
    }

    public void resetIndex() {
        this.myRootInfos.clear();
        this.myNonInterestingIds.clear();
        this.myInitializer.consume((Object)this);
    }

    public void putInfo(@Nullable VirtualFile file2, @NotNull T value) {
        if (!(file2 instanceof VirtualFileWithId)) {
            return;
        }
        this.myRootInfos.put(file2, value);
    }

    @NotNull
    public T getInfoForFile(@Nullable VirtualFile file2) {
        if (!(file2 instanceof VirtualFileWithId) || !file2.isValid()) {
            return this.myDefValue;
        }
        for (VirtualFile each = file2; each != null; each = each.getParent()) {
            int id = ((VirtualFileWithId)each).getId();
            if (this.myNonInterestingIds.get(id)) continue;
            T info = this.myRootInfos.get(each);
            if (info != null) {
                return info;
            }
            this.myNonInterestingIds.set(id);
        }
        return this.myDefValue;
    }
}

