/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SingleEntryIndexer<V>
implements DataIndexer<Integer, V, FileContent> {
    private final boolean myAcceptNullValues;

    protected SingleEntryIndexer(boolean acceptNullValues) {
        this.myAcceptNullValues = acceptNullValues;
    }

    @NotNull
    public final Map<Integer, V> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            return Collections.emptyMap();
        }
        V value = this.computeValue(inputData);
        if (value == null && !this.myAcceptNullValues) {
            return Collections.emptyMap();
        }
        int key = Math.abs(FileBasedIndex.getFileId((VirtualFile)inputData.getFile()));
        return Collections.singletonMap(key, value);
    }

    @Nullable
    protected abstract V computeValue(@NotNull FileContent var1);
}

