/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubstitutedFileType
extends LanguageFileType {
    @NotNull
    private final FileType myOriginalFileType;
    @NotNull
    private final FileType myFileType;

    private SubstitutedFileType(@NotNull FileType originalFileType, @NotNull LanguageFileType substitutionFileType, @NotNull Language substitutedLanguage) {
        super(substitutedLanguage);
        this.myOriginalFileType = originalFileType;
        this.myFileType = substitutionFileType;
    }

    @NotNull
    public static FileType substituteFileType(@NotNull VirtualFile file2, @NotNull FileType fileType, @Nullable Project project) {
        LanguageFileType substFileType;
        Language language;
        Language substitutedLanguage;
        if (project == null) {
            return fileType;
        }
        if (fileType instanceof LanguageFileType && !(substitutedLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(language = ((LanguageFileType)fileType).getLanguage(), file2, project)).equals(language) && (substFileType = substitutedLanguage.getAssociatedFileType()) != null) {
            return new SubstitutedFileType(fileType, substFileType, substitutedLanguage);
        }
        return fileType;
    }

    @NotNull
    public String getName() {
        return this.myFileType.getName();
    }

    @NotNull
    public String getDescription() {
        return this.myFileType.getDescription();
    }

    @NotNull
    public String getDefaultExtension() {
        return this.myFileType.getDefaultExtension();
    }

    public Icon getIcon() {
        return this.myFileType.getIcon();
    }

    public String getCharset(@NotNull VirtualFile file2, @NotNull byte[] content) {
        return this.myFileType.getCharset(file2, content);
    }

    @NotNull
    public FileType getOriginalFileType() {
        return this.myOriginalFileType;
    }

    @NotNull
    public FileType getFileType() {
        return this.myFileType;
    }

    public boolean isSameFileType() {
        return this.myFileType.equals(this.myOriginalFileType);
    }

    public String toString() {
        return "SubstitutedFileType: original=" + this.myOriginalFileType + "; substituted=" + this.myFileType;
    }
}

