/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.SharedIndicesData;
import com.intellij.util.indexing.SharedMapBasedForwardIndex;
import com.intellij.util.indexing.SnapshotInputMappings;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.CollectionInputDataDiffBuilder;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.InputIndexDataExternalizer;
import com.intellij.util.indexing.impl.KeyCollectionBasedForwardIndex;
import com.intellij.util.indexing.impl.MapBasedForwardIndex;
import com.intellij.util.indexing.impl.MapInputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.UpdateData;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentHashMapValueStorage;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsAwareMapReduceIndex<Key, Value, Input>
extends MapReduceIndex<Key, Value, Input>
implements UpdatableIndex<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance(VfsAwareMapReduceIndex.class);
    private final AtomicBoolean myInMemoryMode = new AtomicBoolean();
    private final TIntObjectHashMap<Map<Key, Value>> myInMemoryKeysAndValues = new TIntObjectHashMap();
    private final SnapshotInputMappings<Key, Value, Input> mySnapshotInputMappings;

    public VfsAwareMapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage2) throws IOException {
        this(extension, storage2, VfsAwareMapReduceIndex.getForwardIndex(extension));
        if (!(this.myIndexId instanceof ID)) {
            throw new IllegalArgumentException("myIndexId should be instance of com.intellij.util.indexing.ID");
        }
    }

    public VfsAwareMapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage2, @Nullable ForwardIndex<Key, Value> forwardIndex) throws IOException {
        super(extension, storage2, forwardIndex);
        SharedIndicesData.registerIndex((ID)this.myIndexId, extension);
        this.mySnapshotInputMappings = this.myForwardIndex == null && VfsAwareMapReduceIndex.hasSnapshotMapping(extension) ? new SnapshotInputMappings<Key, Value, Input>(extension) : null;
        this.installMemoryModeListener();
    }

    private static <Key, Value> boolean hasSnapshotMapping(@NotNull IndexExtension<Key, Value, ?> indexExtension) {
        return indexExtension instanceof FileBasedIndexExtension && ((FileBasedIndexExtension)indexExtension).hasSnapshotMapping() && IdIndex.ourSnapshotMappingsEnabled;
    }

    @NotNull
    protected UpdateData<Key, Value> calculateUpdateData(int inputId, @Nullable Input content) {
        int hashId;
        Map<Key, Value> data;
        boolean isContentPhysical = this.isContentPhysical(content);
        if (this.mySnapshotInputMappings != null && content != null && isContentPhysical) {
            SnapshotInputMappings.Snapshot<Key, Value> snapshot = this.mySnapshotInputMappings.readPersistentDataOrMap(content);
            data = snapshot.getData();
            hashId = snapshot.getHashId();
        } else {
            data = this.mapInput(content);
            hashId = 0;
        }
        return this.createUpdateData(data, () -> {
            if (this.mySnapshotInputMappings != null && isContentPhysical) {
                return new MapInputDataDiffBuilder(inputId, this.mySnapshotInputMappings.readInputKeys(inputId));
            }
            if (this.myInMemoryMode.get()) {
                TIntObjectHashMap<Map<Key, Value>> tIntObjectHashMap = this.myInMemoryKeysAndValues;
                synchronized (tIntObjectHashMap) {
                    Map keysAndValues = (Map)this.myInMemoryKeysAndValues.get(inputId);
                    if (keysAndValues != null) {
                        return new MapInputDataDiffBuilder(inputId, keysAndValues);
                    }
                }
                if (this.mySnapshotInputMappings != null) {
                    return new MapInputDataDiffBuilder(inputId, this.mySnapshotInputMappings.readInputKeys(inputId));
                }
            }
            return this.getKeysDiffBuilder(inputId);
        }, () -> {
            if (this.myInMemoryMode.get()) {
                TIntObjectHashMap<Map<Key, Value>> tIntObjectHashMap = this.myInMemoryKeysAndValues;
                synchronized (tIntObjectHashMap) {
                    this.myInMemoryKeysAndValues.put(inputId, (Object)data);
                }
            } else if (this.mySnapshotInputMappings != null) {
                this.mySnapshotInputMappings.putInputHash(inputId, hashId);
            } else {
                this.myForwardIndex.putInputData(inputId, data);
            }
        });
    }

    @Override
    public void setIndexedStateForFile(int fileId, @NotNull VirtualFile file2) {
        IndexingStamp.setFileIndexedStateCurrent(fileId, (ID)this.myIndexId);
    }

    @Override
    public void resetIndexedStateForFile(int fileId) {
        IndexingStamp.setFileIndexedStateOutdated(fileId, (ID)this.myIndexId);
    }

    @Override
    public boolean isIndexedStateForFile(int fileId, @NotNull VirtualFile file2) {
        return IndexingStamp.isFileIndexedStateCurrent(fileId, (ID)this.myIndexId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransientDataForFile(int inputId) {
        Lock lock = this.getWriteLock();
        lock.lock();
        try {
            Set keyCollection;
            TIntObjectHashMap<Map<Key, Value>> tIntObjectHashMap = this.myInMemoryKeysAndValues;
            synchronized (tIntObjectHashMap) {
                Map keyValueMap = (Map)this.myInMemoryKeysAndValues.remove(inputId);
                keyCollection = keyValueMap != null ? keyValueMap.keySet() : null;
            }
            if (keyCollection == null) {
                return;
            }
            try {
                this.removeTransientDataForKeys(inputId, keyCollection);
                Object builder2 = this.mySnapshotInputMappings != null ? new MapInputDataDiffBuilder(inputId, this.mySnapshotInputMappings.readInputKeys(inputId)) : this.getKeysDiffBuilder(inputId);
                if (builder2 instanceof CollectionInputDataDiffBuilder) {
                    Collection keyCollectionFromDisk = ((CollectionInputDataDiffBuilder)builder2).getSeq();
                    if (keyCollectionFromDisk != null) {
                        this.removeTransientDataForKeys(inputId, keyCollectionFromDisk);
                    }
                } else {
                    THashSet diskKeySet = new THashSet();
                    builder2.differentiate(Collections.emptyMap(), (key, value, inputId1) -> {}, (key, value, inputId1) -> {}, (arg_0, arg_1) -> VfsAwareMapReduceIndex.lambda$removeTransientDataForFile$4((Set)diskKeySet, arg_0, arg_1));
                    this.removeTransientDataForKeys(inputId, (Collection<? extends Key>)diskKeySet);
                }
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void removeTransientDataForKeys(int inputId, @NotNull Collection<? extends Key> keys) {
        MemoryIndexStorage memoryIndexStorage = (MemoryIndexStorage)this.getStorage();
        for (Key key : keys) {
            memoryIndexStorage.clearMemoryMapForId(key, inputId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAllKeys(@NotNull Processor<? super Key> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) throws StorageException {
        Lock lock = this.getReadLock();
        lock.lock();
        try {
            boolean bl = ((VfsAwareIndexStorage)this.myStorage).processKeys(processor2, scope, idFilter);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    protected void requestRebuild(@NotNull Throwable ex) {
        Runnable action = () -> FileBasedIndex.getInstance().requestRebuild((ID)this.myIndexId, ex);
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            TransactionGuard.getInstance().submitTransactionLater((Disposable)application, action);
        } else {
            action.run();
        }
    }

    protected void doClear() throws StorageException, IOException {
        super.doClear();
        if (this.mySnapshotInputMappings != null) {
            try {
                this.mySnapshotInputMappings.clear();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    protected void doFlush() throws IOException, StorageException {
        super.doFlush();
        if (this.mySnapshotInputMappings != null) {
            this.mySnapshotInputMappings.flush();
        }
    }

    protected void doDispose() throws StorageException {
        super.doDispose();
        if (this.mySnapshotInputMappings != null) {
            try {
                this.mySnapshotInputMappings.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Nullable
    private static <Key, Value> ForwardIndex<Key, Value> getForwardIndex(@NotNull IndexExtension<Key, Value, ?> indexExtension) throws IOException {
        if (VfsAwareMapReduceIndex.hasSnapshotMapping(indexExtension)) {
            return null;
        }
        if (!(indexExtension instanceof CustomInputsIndexFileBasedIndexExtension)) {
            return new MyMapBasedForwardIndex<Key, Value>(indexExtension);
        }
        MyForwardIndex<Key, Value> backgroundIndex = !SharedIndicesData.ourFileSharedIndicesEnabled || SharedIndicesData.DO_CHECKS ? new MyForwardIndex<Key, Value>(indexExtension) : null;
        return new SharedMapBasedForwardIndex<Key, Value>(indexExtension, backgroundIndex);
    }

    private boolean isContentPhysical(Input content) {
        return content == null || content instanceof UserDataHolder && (Boolean)FileBasedIndexImpl.ourPhysicalContentKey.get((UserDataHolder)content, (Object)Boolean.FALSE) != false;
    }

    private void installMemoryModeListener() {
        IndexStorage storage2 = this.getStorage();
        if (storage2 instanceof MemoryIndexStorage) {
            ((MemoryIndexStorage)storage2).addBufferingStateListener(new MemoryIndexStorage.BufferingStateListener(){

                @Override
                public void bufferingStateChanged(boolean newState) {
                    VfsAwareMapReduceIndex.this.myInMemoryMode.set(newState);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void memoryStorageCleared() {
                    TIntObjectHashMap tIntObjectHashMap = VfsAwareMapReduceIndex.this.myInMemoryKeysAndValues;
                    synchronized (tIntObjectHashMap) {
                        VfsAwareMapReduceIndex.this.myInMemoryKeysAndValues.clear();
                    }
                }
            });
        }
    }

    protected static <K> DataExternalizer<Collection<K>> createInputsIndexExternalizer(IndexExtension<K, ?, ?> extension) {
        return extension instanceof CustomInputsIndexFileBasedIndexExtension ? ((CustomInputsIndexFileBasedIndexExtension)extension).createExternalizer() : new InputIndexDataExternalizer(extension.getKeyDescriptor(), extension.getName());
    }

    private static /* synthetic */ void lambda$removeTransientDataForFile$4(Set diskKeySet, Object key, int inputId1) throws StorageException {
        diskKeySet.add(key);
    }

    static {
        if (!DebugAssertions.DEBUG) {
            Application app = ApplicationManager.getApplication();
            DebugAssertions.DEBUG = app.isEAP() || app.isInternal();
        }
    }

    static class MapDataExternalizer<Key, Value>
    implements DataExternalizer<Map<Key, Value>> {
        final DataExternalizer<Value> myValueExternalizer;
        private final DataExternalizer<Collection<Key>> mySnapshotIndexExternalizer;

        MapDataExternalizer(IndexExtension<Key, Value, ?> extension) {
            this.myValueExternalizer = extension.getValueExternalizer();
            this.mySnapshotIndexExternalizer = VfsAwareMapReduceIndex.createInputsIndexExternalizer(extension);
        }

        public void save(@NotNull DataOutput stream, Map<Key, Value> data) throws IOException {
            int size = data.size();
            DataInputOutputUtil.writeINT((DataOutput)stream, (int)size);
            if (size > 0) {
                THashMap values = new THashMap();
                List keysForNullValue = null;
                for (Map.Entry<Key, Value> e : data.entrySet()) {
                    List keys;
                    Value value = e.getValue();
                    List list2 = keys = value != null ? (List)values.get(value) : keysForNullValue;
                    if (keys == null) {
                        if (value != null) {
                            keys = new SmartList();
                            values.put(value, (Object)keys);
                        } else {
                            keys = keysForNullValue = new SmartList();
                        }
                    }
                    keys.add(e.getKey());
                }
                if (keysForNullValue != null) {
                    this.myValueExternalizer.save(stream, null);
                    this.mySnapshotIndexExternalizer.save(stream, keysForNullValue);
                }
                for (Map.Entry<Object, Object> value : values.keySet()) {
                    this.myValueExternalizer.save(stream, value);
                    this.mySnapshotIndexExternalizer.save(stream, values.get(value));
                }
            }
        }

        public Map<Key, Value> read(@NotNull DataInput in) throws IOException {
            int pairs = DataInputOutputUtil.readINT((DataInput)in);
            if (pairs == 0) {
                return Collections.emptyMap();
            }
            THashMap result2 = new THashMap(pairs);
            while (((InputStream)((Object)in)).available() > 0) {
                Object value = this.myValueExternalizer.read(in);
                Collection keys = (Collection)this.mySnapshotIndexExternalizer.read(in);
                for (Object k : keys) {
                    result2.put(k, value);
                }
            }
            return result2;
        }
    }

    private static class MyForwardIndex<Key, Value>
    extends KeyCollectionBasedForwardIndex<Key, Value> {
        protected MyForwardIndex(IndexExtension<Key, Value, ?> indexExtension) throws IOException {
            super(indexExtension);
        }

        @NotNull
        public PersistentHashMap<Integer, Collection<Key>> createMap() throws IOException {
            PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(Boolean.TRUE);
            try {
                PersistentHashMap persistentHashMap = MyForwardIndex.createIdToDataKeysIndex(this.myIndexExtension);
                return persistentHashMap;
            }
            finally {
                PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(Boolean.FALSE);
            }
        }

        @NotNull
        private static <K> PersistentHashMap<Integer, Collection<K>> createIdToDataKeysIndex(@NotNull IndexExtension<K, ?, ?> extension) throws IOException {
            File indexStorageFile = IndexInfrastructure.getInputIndexStorageFile((ID)extension.getName());
            return new PersistentHashMap(indexStorageFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, VfsAwareMapReduceIndex.createInputsIndexExternalizer(extension));
        }
    }

    private static class MyMapBasedForwardIndex<Key, Value>
    extends MapBasedForwardIndex<Key, Value, Map<Key, Value>> {
        protected MyMapBasedForwardIndex(IndexExtension<Key, Value, ?> indexExtension) throws IOException {
            super(indexExtension);
        }

        @NotNull
        public PersistentHashMap<Integer, Map<Key, Value>> createMap() throws IOException {
            PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(Boolean.TRUE);
            try {
                File indexStorageFile = IndexInfrastructure.getInputIndexStorageFile((ID)this.myIndexExtension.getName());
                PersistentHashMap persistentHashMap = new PersistentHashMap(indexStorageFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, new MapDataExternalizer(this.myIndexExtension));
                return persistentHashMap;
            }
            finally {
                PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(Boolean.FALSE);
            }
        }

        protected InputDataDiffBuilder<Key, Value> getDiffBuilder(int inputId, Map<Key, Value> map2) throws IOException {
            return new MapInputDataDiffBuilder(inputId, map2);
        }

        protected Map<Key, Value> convertToMapValueType(int inputId, Map<Key, Value> map2) throws IOException {
            return map2;
        }
    }
}

