/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.indexing.FileBasedIndexImpl;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsEventsMerger {
    static final boolean DEBUG = false;
    private final AtomicInteger myPublishedEventIndex = new AtomicInteger();
    private final IntObjectMap<ChangeInfo> myChangeInfos = ContainerUtil.createConcurrentIntObjectMap();
    private static final short FILE_ADDED = 1;
    private static final short FILE_REMOVED = 2;
    private static final short FILE_CONTENT_CHANGED = 4;
    private static final short BEFORE_FILE_CONTENT_CHANGED = 8;
    private static final short FILE_TRANSIENT_STATE_CHANGED = 16;

    public void recordFileEvent(int fileId, @NotNull VirtualFile file2, boolean contentChange) {
        this.updateChange(fileId, file2, contentChange ? (short)4 : 1);
    }

    public void recordBeforeFileEvent(int fileId, @NotNull VirtualFile file2, boolean contentChanged) {
        this.updateChange(fileId, file2, contentChanged ? (short)8 : 2);
    }

    public void recordTransientStateChangeEvent(int fileId, @NotNull VirtualFile file2) {
        this.updateChange(fileId, file2, (short)16);
    }

    int getPublishedEventIndex() {
        return this.myPublishedEventIndex.get();
    }

    private void updateChange(int fileId, @NotNull VirtualFile file2, short mask) {
        ChangeInfo existingChangeInfo;
        ChangeInfo newChangeInfo;
        while (this.myChangeInfos.put(fileId, (Object)(newChangeInfo = new ChangeInfo(file2, mask, existingChangeInfo = (ChangeInfo)this.myChangeInfos.get(fileId)))) != existingChangeInfo) {
        }
        this.myPublishedEventIndex.incrementAndGet();
    }

    public boolean processChanges(@NotNull VfsEventProcessor eventProcessor) {
        if (!this.myChangeInfos.isEmpty()) {
            int[] fileIds;
            for (int fileId : fileIds = this.myChangeInfos.keys()) {
                ProgressManager.checkCanceled();
                ChangeInfo info = (ChangeInfo)this.myChangeInfos.remove(fileId);
                if (info == null) continue;
                try {
                    if (!eventProcessor.process(info)) {
                        return false;
                    }
                }
                catch (ProcessCanceledException pce) {
                    FileBasedIndexImpl.LOG.error((Throwable)pce);
                    assert (false);
                }
            }
        }
        return true;
    }

    public boolean hasChanges() {
        return !this.myChangeInfos.isEmpty();
    }

    int getApproximateChangesCount() {
        return this.myChangeInfos.size();
    }

    Stream<VirtualFile> getChangedFiles() {
        return this.myChangeInfos.values().stream().map(ChangeInfo::getFile);
    }

    public static class ChangeInfo {
        private final VirtualFile file;
        private final short eventMask;

        ChangeInfo(@NotNull VirtualFile file2, short eventMask, @Nullable ChangeInfo previous) {
            this.file = file2;
            this.eventMask = ChangeInfo.mergeEventMask(previous != null ? previous.eventMask : (short)0, eventMask);
        }

        private static short mergeEventMask(short existingOperation, short newOperation) {
            if (newOperation == 2) {
                return newOperation;
            }
            return (short)(existingOperation | newOperation);
        }

        public String toString() {
            StringBuilder builder2 = new StringBuilder();
            builder2.append("file: ").append(this.file.getPath()).append("\n").append("operation: ");
            if ((this.eventMask & 0x10) != 0) {
                builder2.append("TRANSIENT_STATE_CHANGE ");
            }
            if ((this.eventMask & 8) != 0) {
                builder2.append("UPDATE-REMOVE ");
            }
            if ((this.eventMask & 4) != 0) {
                builder2.append("UPDATE ");
            }
            if ((this.eventMask & 2) != 0) {
                builder2.append("REMOVE ");
            }
            if ((this.eventMask & 1) != 0) {
                builder2.append("ADD ");
            }
            return builder2.toString().trim();
        }

        boolean isBeforeContentChanged() {
            return (this.eventMask & 8) != 0;
        }

        boolean isContentChanged() {
            return (this.eventMask & 4) != 0;
        }

        boolean isFileRemoved() {
            return (this.eventMask & 2) != 0;
        }

        boolean isFileAdded() {
            return (this.eventMask & 1) != 0;
        }

        boolean isTransientStateChanged() {
            return (this.eventMask & 0x10) != 0;
        }

        @NotNull
        VirtualFile getFile() {
            return this.file;
        }

        int getFileId() {
            int fileId = FileBasedIndexImpl.getIdMaskingNonIdBasedFile(this.file);
            if (fileId < 0) {
                fileId = -fileId;
            }
            return fileId;
        }
    }

    @FunctionalInterface
    public static interface VfsEventProcessor {
        public boolean process(@NotNull ChangeInfo var1);
    }
}

