/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.socketConnection.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.socketConnection.AbstractRequest;
import com.intellij.util.io.socketConnection.AbstractResponse;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.RequestResponseExternalizerFactory;
import com.intellij.util.io.socketConnection.impl.SocketConnectionBase;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerSocketConnectionImpl<Request extends AbstractRequest, Response extends AbstractResponse>
extends SocketConnectionBase<Request, Response> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.io.socketConnection.impl.ServerSocketConnectionImpl");
    private ServerSocket myServerSocket;
    private final int myDefaultPort;
    private final int myPortChoiceAttempts;
    @Nullable
    private final InetAddress myBindAddress;

    public ServerSocketConnectionImpl(int defaultPort, @Nullable InetAddress bindAddress, int portChoiceAttempts, @NotNull RequestResponseExternalizerFactory<Request, Response> factory) {
        super(factory);
        this.myDefaultPort = defaultPort;
        this.myPortChoiceAttempts = portChoiceAttempts;
        this.myBindAddress = bindAddress;
    }

    @Override
    public void open() throws IOException {
        this.myServerSocket = this.createSocket();
        this.setPort(this.myServerSocket.getLocalPort());
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.waitForConnection();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                this.setStatus(ConnectionStatus.CONNECTION_FAILED, "Connection failed: " + e.getMessage());
            }
        });
    }

    @NotNull
    private ServerSocket createSocket() throws IOException {
        IOException exc = null;
        for (int i = 0; i < this.myPortChoiceAttempts; ++i) {
            int port = this.myDefaultPort + i;
            try {
                return new ServerSocket(port, 0, this.myBindAddress);
            }
            catch (IOException e) {
                exc = e;
                LOG.info((Throwable)e);
                continue;
            }
        }
        throw exc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForConnection() throws IOException {
        this.addThreadToInterrupt();
        try {
            this.setStatus(ConnectionStatus.WAITING_FOR_CONNECTION, null);
            LOG.debug("waiting for connection on port " + this.getPort());
            try (Socket socket = this.myServerSocket.accept();){
                this.attachToSocket(socket);
            }
        }
        finally {
            this.myServerSocket.close();
            this.removeThreadToInterrupt();
        }
    }
}

