/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.textCompletion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValuesCompletionProvider<T>
implements TextCompletionProvider {
    @NotNull
    protected final TextCompletionValueDescriptor<T> myDescriptor;
    @NotNull
    private final List<Character> mySeparators;
    @NotNull
    protected final Collection<? extends T> myValues;
    private final boolean myCaseSensitive;
    @NotNull
    private final InsertHandler<LookupElement> myInsertHandler = new CompletionCharInsertHandler();

    public ValuesCompletionProvider(@NotNull TextCompletionValueDescriptor<T> descriptor, @NotNull List<Character> separators, @NotNull Collection<? extends T> values, boolean caseSensitive) {
        this.myDescriptor = descriptor;
        this.mySeparators = separators;
        this.myValues = values;
        this.myCaseSensitive = caseSensitive;
    }

    public ValuesCompletionProvider(@NotNull TextCompletionValueDescriptor<T> presentation, @NotNull Collection<? extends T> values) {
        this(presentation, Collections.emptyList(), values, false);
    }

    @Override
    @Nullable
    public String getAdvertisement() {
        return "";
    }

    @Override
    @Nullable
    public String getPrefix(@NotNull String text, int offset) {
        return ValuesCompletionProvider.getPrefix(text, offset, this.mySeparators);
    }

    @NotNull
    protected static String getPrefix(@NotNull String text, int offset, @NotNull Collection<Character> separators) {
        int index = -1;
        for (char c : separators) {
            index = Math.max(text.lastIndexOf(c, offset - 1), index);
        }
        return text.substring(index + 1, offset);
    }

    @Override
    @NotNull
    public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result2, @NotNull String prefix) {
        CompletionResultSet resultWithMatcher = result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(prefix));
        if (!this.myCaseSensitive) {
            resultWithMatcher = resultWithMatcher.caseInsensitive();
        }
        return resultWithMatcher;
    }

    @Override
    @Nullable
    public CharFilter.Result acceptChar(char c) {
        if (!this.mySeparators.contains(Character.valueOf(c))) {
            return CharFilter.Result.ADD_TO_PREFIX;
        }
        return CharFilter.Result.HIDE_LOOKUP;
    }

    @Override
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        List values = this.getValues(prefix, result2);
        values = ContainerUtil.sorted(values, this.myDescriptor);
        for (Object completionVariant : values) {
            result2.addElement(this.installInsertHandler(this.myDescriptor.createLookupBuilder(completionVariant)));
        }
        result2.stopHere();
    }

    @NotNull
    protected LookupElement installInsertHandler(@NotNull LookupElementBuilder builder2) {
        final InsertHandler handler2 = builder2.getInsertHandler();
        if (handler2 == null) {
            return builder2.withInsertHandler(this.myInsertHandler);
        }
        return builder2.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                ValuesCompletionProvider.this.myInsertHandler.handleInsert(context, item);
                handler2.handleInsert(context, item);
            }
        });
    }

    @NotNull
    protected Collection<? extends T> getValues(@NotNull String prefix, @NotNull CompletionResultSet result2) {
        return this.myValues;
    }

    public static class ValuesCompletionProviderDumbAware<T>
    extends ValuesCompletionProvider<T>
    implements DumbAware {
        public ValuesCompletionProviderDumbAware(@NotNull TextCompletionValueDescriptor<T> descriptor, @NotNull List<Character> separators, @NotNull Collection<? extends T> values, boolean caseSensitive) {
            super(descriptor, separators, values, caseSensitive);
        }

        public ValuesCompletionProviderDumbAware(@NotNull TextCompletionValueDescriptor<T> presentation, @NotNull Collection<? extends T> values) {
            super(presentation, values);
        }
    }

    public class CompletionCharInsertHandler
    implements InsertHandler<LookupElement> {
        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            context.setAddCompletionChar(ValuesCompletionProvider.this.mySeparators.contains(Character.valueOf(context.getCompletionChar())));
        }
    }
}

