/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.treeWithCheckedNodes;

import com.intellij.util.Processor;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.treeWithCheckedNodes.TreeNodeState;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectedState<T> {
    private final Set<T> mySelected;
    private final SLRUMap<T, TreeNodeState> myCache;
    private final int mySelectedSize;

    public SelectedState(int selectedSize, int queueSize) {
        this.mySelectedSize = selectedSize;
        assert (queueSize > 0);
        this.mySelected = new HashSet();
        this.myCache = new SLRUMap(queueSize, queueSize);
    }

    @Nullable
    public TreeNodeState get(T node) {
        if (this.mySelected.contains(node)) {
            return TreeNodeState.SELECTED;
        }
        return (TreeNodeState)((Object)this.myCache.get(node));
    }

    public void clear(T node) {
        this.myCache.remove(node);
        this.mySelected.remove(node);
    }

    public void clearAllCachedMatching(Processor<? super T> processor2) {
        Set entries2 = this.myCache.entrySet();
        for (Map.Entry entry : entries2) {
            if (!processor2.process(entry.getKey())) continue;
            this.myCache.remove(entry.getKey());
        }
    }

    public void remove(T node) {
        this.mySelected.remove(node);
        this.myCache.remove(node);
    }

    @NotNull
    public TreeNodeState putAndPass(T node, @NotNull TreeNodeState state) {
        if (TreeNodeState.SELECTED.equals((Object)state)) {
            this.mySelected.add(node);
            this.myCache.remove(node);
        } else {
            this.mySelected.remove(node);
            this.myCache.put(node, (Object)state);
        }
        return state;
    }

    public boolean canAddSelection() {
        return this.mySelected.size() < this.mySelectedSize;
    }

    public Set<T> getSelected() {
        return Collections.unmodifiableSet(this.mySelected);
    }

    public void setSelection(Collection<? extends T> files2) {
        this.mySelected.clear();
        this.mySelected.addAll(files2);
    }
}

