/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PairProcessor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.ElementProducer;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.util.List;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CollectionModelEditor<T, E extends CollectionItemEditor<T>>
implements ElementProducer<T> {
    protected static final Logger LOG = Logger.getInstance(CollectionModelEditor.class);
    protected final E itemEditor;
    protected final ModelHelper helper = new ModelHelper();

    protected CollectionModelEditor(@NotNull E itemEditor) {
        this.itemEditor = itemEditor;
    }

    public T createElement() {
        return (T)ReflectionUtil.newInstance(this.itemEditor.getItemClass());
    }

    public boolean canCreateElement() {
        return true;
    }

    @NotNull
    protected abstract List<T> getItems();

    public void reset(@NotNull List<T> originalItems) {
        this.helper.reset(originalItems);
    }

    public final boolean isModified() {
        List<T> items = this.getItems();
        OrderedSet oldItems = this.helper.originalItems;
        if (items.size() != oldItems.size()) {
            return true;
        }
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            if (items.get(i).equals(oldItems.get(i))) continue;
            return true;
        }
        return false;
    }

    public void processModifiedItems(final @NotNull PairProcessor<T, T> processor2) {
        this.helper.process(new TObjectObjectProcedure<T, T>(){

            public boolean execute(T newItem, T oldItem) {
                return processor2.process(newItem, oldItem);
            }
        });
    }

    @NotNull
    public final T getMutable(@NotNull T item) {
        return this.helper.getMutable(item, -1);
    }

    protected boolean isEditable(@NotNull T item) {
        return true;
    }

    protected void silentlyReplaceItem(@NotNull T oldItem, @NotNull T newItem, int index) {
        List<T> items = this.getItems();
        items.set(index == -1 ? ContainerUtil.indexOfIdentity(items, oldItem) : index, newItem);
    }

    protected final boolean areSelectedItemsRemovable(@NotNull ListSelectionModel selectionMode) {
        int minSelectionIndex = selectionMode.getMinSelectionIndex();
        int maxSelectionIndex = selectionMode.getMaxSelectionIndex();
        if (minSelectionIndex < 0 || maxSelectionIndex < 0) {
            return false;
        }
        List<T> items = this.getItems();
        for (int i = minSelectionIndex; i <= maxSelectionIndex; ++i) {
            if (!this.itemEditor.isRemovable(items.get(i))) continue;
            return true;
        }
        return false;
    }

    protected class ModelHelper {
        final OrderedSet<T> originalItems = new OrderedSet(ContainerUtil.identityStrategy());
        private final THashMap<T, T> modifiedToOriginal = ContainerUtil.newIdentityTroveMap();
        private final THashMap<T, T> originalToModified = ContainerUtil.newIdentityTroveMap();

        protected ModelHelper() {
        }

        public void reset(@Nullable List<T> newOriginalItems) {
            if (newOriginalItems != null) {
                this.originalItems.clear();
                this.originalItems.addAll(newOriginalItems);
            }
            this.modifiedToOriginal.clear();
            this.originalToModified.clear();
        }

        public void remove(@NotNull T item) {
            Object original = this.modifiedToOriginal.remove(item);
            if (original != null) {
                this.originalToModified.remove(original);
            }
        }

        public boolean isMutable(@NotNull T item) {
            return this.modifiedToOriginal.containsKey(item) || !this.originalItems.contains(item);
        }

        @NotNull
        public T getMutable(@NotNull T item, int index) {
            if (this.isMutable(item) || !CollectionModelEditor.this.isEditable(item)) {
                return item;
            }
            Object mutable = this.originalToModified.get(item);
            if (mutable == null) {
                mutable = CollectionModelEditor.this.itemEditor.clone(item, false);
                this.modifiedToOriginal.put(mutable, item);
                this.originalToModified.put(item, mutable);
                CollectionModelEditor.this.silentlyReplaceItem(item, mutable, index);
            }
            return mutable;
        }

        public boolean hasModifiedItems() {
            return !this.modifiedToOriginal.isEmpty();
        }

        public void process(@NotNull TObjectObjectProcedure<T, T> procedure) {
            this.modifiedToOriginal.forEachEntry(procedure);
        }
    }
}

