/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedComboBoxEditor;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.util.ui.ListItemEditor;
import com.intellij.util.ui.ListModelEditorBase;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public final class ComboBoxModelEditor<T>
extends ListModelEditorBase<T> {
    private final ComboBox<T> comboBox;

    public ComboBoxModelEditor(@NotNull ListItemEditor<T> itemEditor) {
        super(itemEditor);
        this.comboBox = new ComboBox((ComboBoxModel)((Object)this.model));
        this.comboBox.setEditor((ComboBoxEditor)((Object)new NameEditor()));
        this.comboBox.setRenderer((ListCellRenderer)((Object)new MyListCellRenderer()));
    }

    @Override
    @NotNull
    public MutableCollectionComboBoxModel<T> getModel() {
        return this.model;
    }

    @NotNull
    public ComboBox getComboBox() {
        return this.comboBox;
    }

    private class MyListCellRenderer
    extends ListCellRendererWrapper<T> {
        private MyListCellRenderer() {
        }

        public void customize(JList list2, T item, int index, boolean selected, boolean hasFocus) {
            if (item != null) {
                this.setText(((ListItemEditor)ComboBoxModelEditor.this.itemEditor).getName(item));
            }
        }
    }

    private class NameEditor
    extends FixedComboBoxEditor {
        private T item = null;
        private boolean mutated;

        NameEditor() {
            this.getField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (NameEditor.this.item != null && ((ListItemEditor)ComboBoxModelEditor.this.itemEditor).isEditable(NameEditor.this.item)) {
                        String newName = NameEditor.this.getField().getText();
                        if (newName.equals(((ListItemEditor)ComboBoxModelEditor.this.itemEditor).getName(NameEditor.this.item))) {
                            return;
                        }
                        if (!NameEditor.this.mutated) {
                            NameEditor.this.mutated = true;
                            NameEditor.this.item = ComboBoxModelEditor.this.getMutable(NameEditor.this.item);
                        }
                        ((KeymapImpl)NameEditor.this.item).setName(newName);
                    }
                }
            });
        }

        public void setItem(Object newItem) {
            if (newItem != null && newItem != this.item) {
                this.item = newItem;
                this.mutated = false;
                this.getField().setText(((ListItemEditor)ComboBoxModelEditor.this.itemEditor).getName(this.item));
            }
        }

        public Object getItem() {
            return this.item;
        }
    }
}

