/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ListItemsDialogWrapper
extends DialogWrapper {
    protected final JPanel myPanel;
    protected final JList<String> myList = new JBList(new DefaultListModel());
    protected List<String> myData;

    public ListItemsDialogWrapper(String title) {
        super(true);
        this.myPanel = ToolbarDecorator.createDecorator(this.myList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                String elementName = ListItemsDialogWrapper.this.createAddItemDialog();
                if (elementName != null) {
                    while (ListItemsDialogWrapper.this.myData.contains(elementName)) {
                        ListItemsDialogWrapper.this.myData.remove(elementName);
                    }
                    ListItemsDialogWrapper.this.myData.add(elementName);
                    ListItemsDialogWrapper.this.updateData();
                    ListItemsDialogWrapper.this.myList.setSelectedIndex(ListItemsDialogWrapper.this.myData.size() - 1);
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                int selectedIndex = ListItemsDialogWrapper.this.myList.getSelectedIndex();
                if (selectedIndex >= 0) {
                    ListItemsDialogWrapper.this.myData.remove(selectedIndex);
                    ListItemsDialogWrapper.this.updateData();
                    if (selectedIndex >= ListItemsDialogWrapper.this.myData.size()) {
                        --selectedIndex;
                    }
                    if (selectedIndex >= 0) {
                        ListItemsDialogWrapper.this.myList.setSelectedIndex(selectedIndex);
                    }
                }
            }
        }).disableUpDownActions().createPanel();
        this.setTitle(title);
        this.init();
    }

    protected abstract String createAddItemDialog();

    public void setData(List<String> data) {
        this.myData = ContainerUtil.newArrayList(data);
        this.updateData();
        if (!this.myData.isEmpty()) {
            this.myList.setSelectedIndex(0);
        }
    }

    protected void updateData() {
        DefaultListModel model = (DefaultListModel)this.myList.getModel();
        model.clear();
        for (String data : this.myData) {
            model.addElement(data);
        }
    }

    @Nullable
    public List<String> getData() {
        return this.myData;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    @NotNull
    public static String createStringPresentation(@Nullable List<String> data) {
        return data == null ? "" : StringUtil.join(data, (String)",");
    }

    @NotNull
    public static List<String> createListPresentation(@Nullable String data) {
        if (data == null || data.trim().isEmpty()) {
            return ContainerUtil.emptyList();
        }
        return ContainerUtil.newArrayList((Object[])data.split(","));
    }

    public static void installListItemsDialogForTextField(final @NotNull TextFieldWithBrowseButton uiField, final @NotNull Producer<? extends ListItemsDialogWrapper> createDialog) {
        uiField.getTextField().setEditable(false);
        uiField.setButtonIcon(PlatformIcons.OPEN_EDIT_DIALOG_ICON);
        uiField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListItemsDialogWrapper tagListDialog = (ListItemsDialogWrapper)((Object)createDialog.produce());
                tagListDialog.setData(ListItemsDialogWrapper.createListPresentation(uiField.getText()));
                if (tagListDialog.showAndGet()) {
                    uiField.setText(ListItemsDialogWrapper.createStringPresentation(tagListDialog.getData()));
                }
            }
        });
    }
}

