/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ListItemEditor;
import com.intellij.util.ui.ListModelEditorBase;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListModelEditor<T>
extends ListModelEditorBase<T> {
    private final ToolbarDecorator toolbarDecorator;
    private final JBList list;

    public ListModelEditor(@NotNull ListItemEditor<T> itemEditor) {
        super(itemEditor);
        this.list = new JBList((ListModel)((Object)this.model));
        this.list.setSelectionMode(0);
        this.list.setCellRenderer((ListCellRenderer)((Object)new MyListCellRenderer()));
        this.toolbarDecorator = ToolbarDecorator.createDecorator((JList)this.list, (EditableModel)this.model).setAddAction(button2 -> {
            Object lastItem;
            if (!this.model.isEmpty() && ((ListItemEditor)this.itemEditor).isEmpty(lastItem = this.model.getElementAt(this.model.getSize() - 1))) {
                ScrollingUtil.selectItem((JList)this.list, (int)ContainerUtil.indexOfIdentity((List)this.model.getItems(), (Object)lastItem));
                return;
            }
            Object item = this.createElement();
            this.model.add(item);
            ScrollingUtil.selectItem((JList)this.list, (int)ContainerUtil.indexOfIdentity((List)this.model.getItems(), item));
        }).setRemoveActionUpdater(e -> this.areSelectedItemsRemovable(this.list.getSelectionModel()));
    }

    @NotNull
    public ListModelEditor<T> disableUpDownActions() {
        this.toolbarDecorator.disableUpDownActions();
        return this;
    }

    @NotNull
    public JComponent createComponent() {
        return this.toolbarDecorator.createPanel();
    }

    @NotNull
    public JBList getList() {
        return this.list;
    }

    @Nullable
    public T getSelected() {
        return (T)this.list.getSelectedValue();
    }

    @Override
    public void reset(@NotNull List<T> items) {
        super.reset(items);
        SwingUtilities.invokeLater(() -> {
            if (!this.model.isEmpty()) {
                this.list.setSelectedIndex(0);
            }
        });
    }

    @Override
    protected void removeEmptyItem(int i) {
        ListUtil.removeIndices((JList)this.getList(), (int[])new int[]{i});
    }

    private class MyListCellRenderer
    extends ColoredListCellRenderer {
        private MyListCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
            this.setBackground(UIUtil.getListBackground((boolean)selected));
            if (value != null) {
                this.append(((ListItemEditor)ListModelEditor.this.itemEditor).getName(value));
            }
        }
    }
}

