/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.dialog;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.DialogWrapper;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.jetbrains.annotations.NotNull;

public final class DialogUtils {
    private DialogUtils() {
    }

    public static void invokeLaterAfterDialogShown(@NotNull DialogWrapper dialog2, final @NotNull Runnable action) {
        final Application application = ApplicationManager.getApplication();
        if (application.isHeadlessEnvironment()) {
            application.invokeLater(action, ModalityState.any());
        } else {
            dialog2.getWindow().addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    Window window = e.getWindow();
                    application.invokeLater(action, ModalityState.stateForComponent((Component)window));
                    window.removeWindowListener(this);
                }
            });
        }
    }
}

