/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.codeInsight.daemon.impl.IntentionActionFilter;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.vcs.commit.ReformatCommitMessageAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCommitMessageInspection
extends LocalInspectionTool {
    public static final String GROUP_NAME = "Commit message";

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return GROUP_NAME;
    }

    @Nullable
    public String getStaticDescription() {
        return "";
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        return !CommitMessage.isCommitMessage(element);
    }

    @Nullable
    public ConfigurableUi<Project> createOptionsConfigurable() {
        return null;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Document document = BaseCommitMessageInspection.getDocument((PsiElement)file2);
        return document != null ? this.checkFile(file2, document, manager, isOnTheFly) : null;
    }

    @Nullable
    protected ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull Document document, @NotNull InspectionManager manager, boolean isOnTheFly) {
        return null;
    }

    @Nullable
    protected static ProblemDescriptor checkRightMargin(@NotNull PsiFile file2, @NotNull Document document, @NotNull InspectionManager manager, boolean isOnTheFly, int line, int rightMargin, @NotNull String problemText, LocalQuickFix ... fixes) {
        int start2 = document.getLineStartOffset(line);
        int end = document.getLineEndOffset(line);
        if (end > start2 + rightMargin) {
            TextRange exceedingRange = new TextRange(start2 + rightMargin, end);
            return manager.createProblemDescriptor((PsiElement)file2, exceedingRange, problemText, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, fixes);
        }
        return null;
    }

    public boolean canReformat(@NotNull Project project, @NotNull Document document) {
        return false;
    }

    public void reformat(@NotNull Project project, @NotNull Document document) {
    }

    protected boolean hasProblems(@NotNull Project project, @NotNull Document document) {
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        return file2 != null && !ArrayUtil.isEmpty((Object[])this.checkFile(file2, document, InspectionManager.getInstance((Project)project), false));
    }

    @Nullable
    private static Document getDocument(@NotNull PsiElement element) {
        return PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile());
    }

    protected static class ReformatCommitMessageQuickFix
    extends BaseCommitMessageQuickFix
    implements LowPriorityAction,
    IntentionAction,
    ShortcutProvider {
        protected ReformatCommitMessageQuickFix() {
            super("Reformat commit message");
        }

        @Override
        public void doApplyFix(@NotNull Project project, @NotNull Document document, @Nullable ProblemDescriptor descriptor) {
            ReformatCommitMessageAction.reformat(project, document);
        }

        @Nullable
        public ShortcutSet getShortcut() {
            return KeymapUtil.getActiveKeymapShortcuts((String)"Vcs.ReformatCommitMessage");
        }

        @Nls
        @NotNull
        public String getText() {
            return this.getName();
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
            return true;
        }

        public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) throws IncorrectOperationException {
            Document document = BaseCommitMessageInspection.getDocument((PsiElement)file2);
            if (document != null) {
                this.doApplyFix(project, document, null);
            }
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    protected static abstract class BaseCommitMessageQuickFix
    extends LocalQuickFixBase {
        protected BaseCommitMessageQuickFix(@NotNull String name) {
            super(name);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Document document = BaseCommitMessageInspection.getDocument(descriptor.getPsiElement());
            if (document != null) {
                this.doApplyFix(project, document, descriptor);
            }
        }

        public abstract void doApplyFix(@NotNull Project var1, @NotNull Document var2, @Nullable ProblemDescriptor var3);
    }

    public static class EmptyIntentionActionFilter
    implements IntentionActionFilter {
        @Override
        public boolean accept(@NotNull IntentionAction intentionAction, @Nullable PsiFile file2) {
            return file2 == null || !CommitMessage.isCommitMessage((PsiElement)file2) || !(intentionAction instanceof EmptyIntentionAction);
        }
    }
}

