/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.util.DocumentUtil;
import com.intellij.vcs.commit.BaseCommitMessageInspection;
import com.intellij.vcs.commit.BodyLimitInspectionOptions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BodyLimitInspection
extends BaseCommitMessageInspection {
    public int RIGHT_MARGIN = 72;

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Limit body line";
    }

    @Override
    @NotNull
    public ConfigurableUi<Project> createOptionsConfigurable() {
        return new BodyLimitInspectionOptions(this);
    }

    @Override
    @Nullable
    protected ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull Document document, @NotNull InspectionManager manager, boolean isOnTheFly) {
        return (ProblemDescriptor[])IntStream.range(1, document.getLineCount()).mapToObj(line -> BodyLimitInspection.checkRightMargin(file2, document, manager, isOnTheFly, line, this.RIGHT_MARGIN, String.format("Body lines should not exceed %d characters", this.RIGHT_MARGIN), new LocalQuickFix[]{new WrapLineQuickFix(), new BaseCommitMessageInspection.ReformatCommitMessageQuickFix()})).filter(Objects::nonNull).toArray(ProblemDescriptor[]::new);
    }

    @Override
    public boolean canReformat(@NotNull Project project, @NotNull Document document) {
        return this.hasProblems(project, document);
    }

    @Override
    public void reformat(@NotNull Project project, @NotNull Document document) {
        new WrapLineQuickFix().doApplyFix(project, document, null);
    }

    protected class WrapLineQuickFix
    extends BaseCommitMessageInspection.BaseCommitMessageQuickFix {
        protected WrapLineQuickFix() {
            super("Wrap line");
        }

        @Override
        public void doApplyFix(@NotNull Project project, @NotNull Document document, @Nullable ProblemDescriptor descriptor) {
            Editor editor = CommitMessage.getEditor(document);
            if (editor != null) {
                TextRange range2;
                TextRange textRange = range2 = descriptor != null && descriptor.getLineNumber() >= 0 ? DocumentUtil.getLineTextRange(document, descriptor.getLineNumber()) : this.getBodyRange(document);
                if (!range2.isEmpty()) {
                    this.wrapLines(project, editor, document, BodyLimitInspection.this.RIGHT_MARGIN, range2);
                }
            }
        }

        @NotNull
        private TextRange getBodyRange(@NotNull Document document) {
            return document.getLineCount() > 1 ? TextRange.create((int)document.getLineStartOffset(1), (int)document.getTextLength()) : TextRange.EMPTY_RANGE;
        }

        private void wrapLines(@NotNull Project project, @NotNull Editor editor, @NotNull Document document, final int rightMargin, @NotNull TextRange range2) {
            CodeFormatterFacade codeFormatter = new CodeFormatterFacade(new CodeStyleSettings(false){

                public int getRightMargin(@Nullable Language language) {
                    return rightMargin;
                }
            }, null);
            List<TextRange> enabledRanges = Collections.singletonList(TextRange.create((int)0, (int)document.getTextLength()));
            codeFormatter.doWrapLongLinesIfNecessary(editor, project, document, range2.getStartOffset(), range2.getEndOffset(), enabledRanges);
        }
    }
}

