/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.ui.LevelChooserAction;
import com.intellij.profile.codeInspection.ui.table.ScopesAndSeveritiesTable;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.vcs.commit.BaseCommitMessageInspection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CommitMessageInspectionDetails
implements UnnamedConfigurable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final InspectionProfileImpl myProfile;
    @NotNull
    private final Descriptor myDefaultDescriptor;
    @NotNull
    private final ScopeToolState myToolState;
    private JPanel mySeverityChooserPanel;
    private LevelChooserAction mySeverityChooser;
    private JComponent myMainPanel;
    private ConfigurableUi<Project> myOptionsConfigurable;
    @NotNull
    private final EventDispatcher<ChangeListener> myEventDispatcher;

    public CommitMessageInspectionDetails(@NotNull Project project, @NotNull InspectionProfileImpl profile2, @NotNull Descriptor defaultDescriptor) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        this.myProject = project;
        this.myProfile = profile2;
        this.myDefaultDescriptor = defaultDescriptor;
        this.myToolState = this.myDefaultDescriptor.getState();
        this.init();
        this.reset();
    }

    @NotNull
    public HighlightDisplayKey getKey() {
        return this.myDefaultDescriptor.getKey();
    }

    public void update() {
        this.mySeverityChooser.setChosen(ScopesAndSeveritiesTable.getSeverity(Collections.singletonList(this.myToolState)));
        GuiUtils.enableChildren((boolean)this.myToolState.isEnabled(), (Component[])new Component[]{this.myMainPanel});
    }

    public void addListener(@NotNull ChangeListener listener2) {
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    @NotNull
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return this.myOptionsConfigurable != null && this.myOptionsConfigurable.isModified((Object)this.myProject);
    }

    public void apply() throws ConfigurationException {
        if (this.myOptionsConfigurable != null) {
            this.myOptionsConfigurable.apply((Object)this.myProject);
        }
    }

    public void reset() {
        if (this.myOptionsConfigurable != null) {
            this.myOptionsConfigurable.reset((Object)this.myProject);
        }
    }

    private void init() {
        JComponent options;
        this.mySeverityChooser = new MySeverityChooser(this.myProfile.getProfileManager().getSeverityRegistrar());
        this.mySeverityChooserPanel.add((Component)this.mySeverityChooser.createCustomComponent(this.mySeverityChooser.getTemplatePresentation(), "unknown"), "Center");
        InspectionProfileEntry tool = this.myToolState.getTool().getTool();
        if (tool instanceof BaseCommitMessageInspection) {
            this.myOptionsConfigurable = ((BaseCommitMessageInspection)tool).createOptionsConfigurable();
        }
        JComponent jComponent = options = this.myOptionsConfigurable != null ? this.myOptionsConfigurable.getComponent() : this.myToolState.getAdditionalConfigPanel();
        if (options != null) {
            this.myMainPanel.add((Component)options, CommitMessageInspectionDetails.createOptionsPanelConstraints());
        }
    }

    @NotNull
    private static GridConstraints createOptionsPanelConstraints() {
        GridConstraints result2 = new GridConstraints();
        result2.setRow(1);
        result2.setColumn(0);
        result2.setRowSpan(1);
        result2.setColSpan(2);
        result2.setAnchor(9);
        result2.setUseParentLayout(true);
        return result2;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2 = new JPanel();
        this.myMainPanel = jPanel2;
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Severity:");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.mySeverityChooserPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 9, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    public static interface ChangeListener
    extends EventListener {
        public void onSeverityChanged(@NotNull HighlightSeverity var1);
    }

    private class MySeverityChooser
    extends LevelChooserAction {
        MySeverityChooser(SeverityRegistrar registrar) {
            super(registrar);
        }

        @Override
        protected void onChosen(@NotNull HighlightSeverity severity) {
            HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
            CommitMessageInspectionDetails.this.myProfile.setErrorLevel(CommitMessageInspectionDetails.this.myDefaultDescriptor.getKey(), level, null, CommitMessageInspectionDetails.this.myProject);
            ((ChangeListener)CommitMessageInspectionDetails.this.myEventDispatcher.getMulticaster()).onSeverityChanged(severity);
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            return this.createComboBoxButton(presentation);
        }
    }
}

