/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.vcs.commit.BaseCommitMessageInspection;
import com.intellij.vcs.commit.BodyLimitInspection;
import com.intellij.vcs.commit.CommitMessageSpellCheckingInspection;
import com.intellij.vcs.commit.SubjectBodySeparationInspection;
import com.intellij.vcs.commit.SubjectLimitInspection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="CommitMessageInspectionProfile", storages={@Storage(value="vcs.xml")})
public class CommitMessageInspectionProfile
extends InspectionProfileImpl
implements PersistentStateComponent<State> {
    private static final String PROFILE_NAME = "Commit Dialog";
    public static final InspectionProfileImpl DEFAULT = new InspectionProfileImpl("Commit Dialog", (Supplier<List<InspectionToolWrapper>>)new CommitMessageInspectionToolSupplier(), (InspectionProfileImpl)null);
    @NotNull
    private final Project myProject;

    public CommitMessageInspectionProfile(@NotNull Project project) {
        super(PROFILE_NAME, (Supplier<List<InspectionToolWrapper>>)new CommitMessageInspectionToolSupplier(), DEFAULT);
        this.myProject = project;
    }

    @NotNull
    public static CommitMessageInspectionProfile getInstance(@NotNull Project project) {
        return (CommitMessageInspectionProfile)ServiceManager.getService((Project)project, CommitMessageInspectionProfile.class);
    }

    public static int getBodyRightMargin(@NotNull Project project) {
        return CommitMessageInspectionProfile.getInstance(project).getBodyRightMargin();
    }

    public static int getSubjectRightMargin(@NotNull Project project) {
        return CommitMessageInspectionProfile.getInstance(project).getSubjectRightMargin();
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    private int getBodyRightMargin() {
        return this.getTool(BodyLimitInspection.class).RIGHT_MARGIN;
    }

    private int getSubjectRightMargin() {
        return this.getTool(SubjectLimitInspection.class).RIGHT_MARGIN;
    }

    public <T extends LocalInspectionTool> T getTool(Class<T> aClass) {
        InspectionToolWrapper tool = this.getInspectionTool(InspectionProfileEntry.getShortName((String)aClass.getSimpleName()), this.myProject);
        return (T)((LocalInspectionTool)((InspectionToolWrapper)ObjectUtils.notNull((Object)tool)).getTool());
    }

    @Override
    protected boolean forceInitInspectionTools() {
        return true;
    }

    @Override
    @Transient
    @NotNull
    public String getName() {
        return super.getName();
    }

    @NotNull
    public State getState() {
        Element element = CommitMessageInspectionProfile.newProfileElement();
        this.writeExternal(element);
        State state = new State();
        state.myProfile = element;
        return state;
    }

    public void loadState(@NotNull State state) {
        this.readExternal(state.myProfile);
    }

    @NotNull
    private static Element newProfileElement() {
        return new Element("profile");
    }

    @NotNull
    private static Element newProfileWithVersionElement() {
        Element result2 = CommitMessageInspectionProfile.newProfileElement();
        CommitMessageInspectionProfile.writeVersion(result2);
        return result2;
    }

    static /* synthetic */ Element access$100() {
        return CommitMessageInspectionProfile.newProfileWithVersionElement();
    }

    private static class CommitMessageInspectionToolSupplier
    implements Supplier<List<InspectionToolWrapper>> {
        private CommitMessageInspectionToolSupplier() {
        }

        @Override
        @NotNull
        public List<InspectionToolWrapper> get() {
            return Stream.of(new BaseCommitMessageInspection[]{new SubjectBodySeparationInspection(), new SubjectLimitInspection(), new BodyLimitInspection(), new CommitMessageSpellCheckingInspection()}).map(LocalInspectionToolWrapper::new).collect(Collectors.toList());
        }
    }

    public static class State {
        @Tag(value="profile")
        public Element myProfile = CommitMessageInspectionProfile.access$100();
    }
}

