/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.ToolDescriptors;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeComparator;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeRenderer;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionsConfigTreeTable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.commit.CommitMessageInspectionDetails;
import com.intellij.vcs.commit.CommitMessageInspectionProfile;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitMessageInspectionsPanel
extends BorderLayoutPanel
implements Disposable,
UnnamedConfigurable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final CommitMessageInspectionProfile myProfile;
    @NotNull
    private final List<ToolDescriptors> myInitialToolDescriptors = ContainerUtil.newArrayList();
    @NotNull
    private final Map<HighlightDisplayKey, CommitMessageInspectionDetails> myToolDetails = ContainerUtil.newHashMap();
    @NotNull
    private final InspectionConfigTreeNode myRoot = new InspectionConfigTreeNode.Group("");
    private InspectionProfileModifiableModel myModifiableModel;
    private InspectionsConfigTreeTable myInspectionsTable;
    private final Wrapper myDetailsPanel = new Wrapper(){

        public boolean isNull() {
            return false;
        }
    };
    private CommitMessageInspectionDetails myCurrentDetails;

    public CommitMessageInspectionsPanel(@NotNull Project project) {
        this.myProject = project;
        this.myProfile = CommitMessageInspectionProfile.getInstance(this.myProject);
        this.resetProfileModel();
        this.init();
        this.setPreferredSize((Dimension)JBUI.size((int)650, (int)120));
    }

    private void resetProfileModel() {
        this.myModifiableModel = new InspectionProfileModifiableModel(this.myProfile);
    }

    private void initToolDescriptors() {
        this.myInitialToolDescriptors.clear();
        for (ScopeToolState state : this.myModifiableModel.getDefaultStates(this.myProject)) {
            this.myInitialToolDescriptors.add(ToolDescriptors.fromScopeToolState(state, this.myModifiableModel, this.myProject));
        }
    }

    private void buildInspectionsModel() {
        this.myRoot.removeAllChildren();
        for (ToolDescriptors toolDescriptors : this.myInitialToolDescriptors) {
            this.myRoot.add(new MyInspectionTreeNode(toolDescriptors));
        }
        TreeUtil.sortRecursively((MutableTreeNode)this.myRoot, InspectionsConfigTreeComparator.INSTANCE);
    }

    private void init() {
        this.myInspectionsTable = InspectionsConfigTreeTable.create(new MyInspectionsTableSettings(this.myRoot, this.myProject), this);
        this.myInspectionsTable.setRootVisible(false);
        this.myInspectionsTable.setTreeCellRenderer((TreeCellRenderer)((Object)new MyInspectionsTreeRenderer()));
        this.myInspectionsTable.setSelectionMode(0);
        this.myInspectionsTable.getTree().getSelectionModel().setSelectionMode(1);
        this.myInspectionsTable.getTree().addTreeSelectionListener(e -> this.updateDetailsPanel());
        this.myInspectionsTable.setBorder(IdeBorderFactory.createBorder());
        JBSplitter splitter = new JBSplitter("CommitMessageInspectionsPanelSplitter", 0.5f);
        splitter.setShowDividerIcon(false);
        splitter.setFirstComponent((JComponent)((Object)this.myInspectionsTable));
        splitter.setSecondComponent((JComponent)this.myDetailsPanel);
        this.addToCenter((Component)splitter);
    }

    private void updateDetailsPanel() {
        MyInspectionTreeNode node = this.getSelectedNode();
        if (node == null && this.myCurrentDetails != null || node != null && (this.myCurrentDetails == null || node.getKey() != this.myCurrentDetails.getKey())) {
            this.setDetails(node);
        }
        if (this.myCurrentDetails != null) {
            this.myCurrentDetails.update();
        }
    }

    private void setDetails(@Nullable MyInspectionTreeNode node) {
        this.myCurrentDetails = node != null ? this.myToolDetails.computeIfAbsent(node.getKey(), key -> this.createDetails(node)) : null;
        this.myDetailsPanel.setContent(this.myCurrentDetails != null ? this.myCurrentDetails.createComponent() : null);
        this.myDetailsPanel.repaint();
    }

    @NotNull
    private CommitMessageInspectionDetails createDetails(@NotNull MyInspectionTreeNode node) {
        CommitMessageInspectionDetails details = new CommitMessageInspectionDetails(this.myProject, this.myModifiableModel, node.getDefaultDescriptor());
        details.addListener(severity -> this.myInspectionsTable.updateUI());
        return details;
    }

    @Nullable
    private MyInspectionTreeNode getSelectedNode() {
        TreePath selectedPath = this.myInspectionsTable.getTree().getPathForRow(this.myInspectionsTable.getSelectedRow());
        return selectedPath != null ? (MyInspectionTreeNode)selectedPath.getLastPathComponent() : null;
    }

    public void dispose() {
    }

    @Nullable
    public JComponent createComponent() {
        return this;
    }

    public void reset() {
        this.myToolDetails.clear();
        this.myModifiableModel.getAllTools().forEach(ScopeToolState::resetConfigPanel);
        this.resetProfileModel();
        this.initToolDescriptors();
        TreeState state = TreeState.createOn((JTree)this.myInspectionsTable.getTree(), (DefaultMutableTreeNode)this.myRoot);
        this.buildInspectionsModel();
        ((DefaultTreeModel)this.myInspectionsTable.getTree().getModel()).reload();
        state.applyTo((JTree)this.myInspectionsTable.getTree(), (Object)this.myRoot);
    }

    public boolean isModified() {
        return ContainerUtil.exists(this.myInitialToolDescriptors, toolDescriptors -> SingleInspectionProfilePanel.areToolDescriptorsChanged(this.myProject, this.myModifiableModel, toolDescriptors)) || ContainerUtil.exists(this.myToolDetails.values(), CommitMessageInspectionDetails::isModified);
    }

    public void apply() throws ConfigurationException {
        for (CommitMessageInspectionDetails details : this.myToolDetails.values()) {
            details.apply();
        }
        this.myModifiableModel.commit();
        this.reset();
    }

    private static class MyInspectionsTreeRenderer
    extends InspectionsConfigTreeRenderer {
        private MyInspectionsTreeRenderer() {
        }

        @Override
        @Nullable
        protected String getFilter() {
            return null;
        }
    }

    private static class MyInspectionTreeNode
    extends InspectionConfigTreeNode.Tool {
        MyInspectionTreeNode(@NotNull ToolDescriptors descriptors) {
            super((Getter<ToolDescriptors>)((Getter)() -> descriptors));
        }

        @Override
        @NotNull
        public Descriptor getDefaultDescriptor() {
            return (Descriptor)ObjectUtils.notNull((Object)super.getDefaultDescriptor());
        }

        @Override
        @NotNull
        public ToolDescriptors getDescriptors() {
            return (ToolDescriptors)ObjectUtils.notNull((Object)super.getDescriptors());
        }

        @Override
        protected boolean calculateIsProperSettings() {
            return false;
        }
    }

    private class MyInspectionsTableSettings
    extends InspectionsConfigTreeTable.InspectionsConfigTreeTableSettings {
        MyInspectionsTableSettings(@NotNull InspectionConfigTreeNode root, Project project) {
            super(root, project);
        }

        @Override
        @NotNull
        protected InspectionProfileImpl getInspectionProfile() {
            return CommitMessageInspectionsPanel.this.myModifiableModel;
        }

        @Override
        protected void onChanged(@NotNull InspectionConfigTreeNode node) {
        }

        @Override
        public void updateRightPanel() {
            CommitMessageInspectionsPanel.this.updateDetailsPanel();
        }
    }
}

