/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.commit.BaseCommitMessageInspection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CommitMessageSpellCheckingInspection
extends BaseCommitMessageInspection {
    private static final Logger LOG = Logger.getInstance(CommitMessageSpellCheckingInspection.class);
    private static final AtomicNullableLazyValue<LocalInspectionTool> ourSpellCheckingInspection = AtomicNullableLazyValue.createValue(() -> {
        LocalInspectionTool result2 = null;
        List<InspectionToolWrapper> tools = InspectionToolRegistrar.getInstance().createTools();
        InspectionToolWrapper spellCheckingWrapper = (InspectionToolWrapper)ContainerUtil.find(tools, wrapper2 -> wrapper2.getShortName().equals("SpellCheckingInspection"));
        if (spellCheckingWrapper == null) {
            LOG.info("Could not find default spell checking inspection");
        } else if (!(spellCheckingWrapper instanceof LocalInspectionToolWrapper)) {
            LOG.info("Found spell checking wrapper is not local " + spellCheckingWrapper);
        } else {
            result2 = (LocalInspectionTool)((LocalInspectionToolWrapper)spellCheckingWrapper).getTool();
        }
        return result2;
    });

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        LocalInspectionTool tool = (LocalInspectionTool)ourSpellCheckingInspection.getValue();
        return tool != null ? tool.buildVisitor(holder, isOnTheFly) : super.buildVisitor(holder, isOnTheFly);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Spelling";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return (HighlightDisplayLevel)ObjectUtils.notNull((Object)HighlightDisplayLevel.find((String)"TYPO"), (Object)HighlightDisplayLevel.WARNING);
    }

    public boolean isEnabledByDefault() {
        return true;
    }
}

