/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.commit.BaseCommitMessageInspection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubjectBodySeparationInspection
extends BaseCommitMessageInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        return "Blank line between subject and body";
    }

    @Override
    @Nullable
    protected ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull Document document, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ProblemDescriptor descriptor = document.getLineCount() > 1 ? SubjectBodySeparationInspection.checkRightMargin(file2, document, manager, isOnTheFly, 1, 0, "Missing blank line between subject and body", new LocalQuickFix[]{new AddBlankLineQuickFix(), new BaseCommitMessageInspection.ReformatCommitMessageQuickFix()}) : null;
        return descriptor != null ? (ProblemDescriptor[])ContainerUtil.ar((Object[])new ProblemDescriptor[]{descriptor}) : null;
    }

    @Override
    public boolean canReformat(@NotNull Project project, @NotNull Document document) {
        return this.hasProblems(project, document);
    }

    @Override
    public void reformat(@NotNull Project project, @NotNull Document document) {
        new AddBlankLineQuickFix().doApplyFix(project, document, null);
    }

    protected static class AddBlankLineQuickFix
    extends BaseCommitMessageInspection.BaseCommitMessageQuickFix {
        protected AddBlankLineQuickFix() {
            super("Add blank line");
        }

        @Override
        public void doApplyFix(@NotNull Project project, @NotNull Document document, @Nullable ProblemDescriptor descriptor) {
            TextRange lineRange;
            int line;
            int n = line = descriptor != null && descriptor.getLineNumber() >= 0 ? descriptor.getLineNumber() : AddBlankLineQuickFix.getFirstLine(document);
            if (line >= 0 && !(lineRange = DocumentUtil.getLineTextRange(document, line)).isEmpty()) {
                document.insertString(lineRange.getStartOffset(), (CharSequence)"\n");
            }
        }

        private static int getFirstLine(@NotNull Document document) {
            return document.getLineCount() > 1 ? 1 : -1;
        }
    }
}

