/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsCommitCache;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractDataGetter<T extends VcsShortCommitDetails>
implements Disposable,
DataGetter<T> {
    private static final Logger LOG = Logger.getInstance(AbstractDataGetter.class);
    private static final int MAX_LOADING_TASKS = 10;
    @NotNull
    protected final VcsLogStorage myStorage;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    private final VcsCommitCache<Integer, T> myCache;
    @NotNull
    private final SequentialLimitedLifoExecutor<TaskDescriptor> myLoader;
    private long myCurrentTaskIndex = 0L;
    @NotNull
    private final Collection<Runnable> myLoadingFinishedListeners = new ArrayList<Runnable>();
    @NotNull
    protected final VcsLogIndex myIndex;

    AbstractDataGetter(@NotNull VcsLogStorage storage2, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsCommitCache<Integer, T> cache, @NotNull VcsLogIndex index, @NotNull Disposable parentDisposable) {
        this.myStorage = storage2;
        this.myLogProviders = logProviders;
        this.myCache = cache;
        this.myIndex = index;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myLoader = new SequentialLimitedLifoExecutor(this, 10, task2 -> {
            this.preLoadCommitData(((TaskDescriptor)task2).myCommits);
            this.notifyLoaded();
        });
    }

    private void notifyLoaded() {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            for (Runnable loadingFinishedListener : this.myLoadingFinishedListeners) {
                loadingFinishedListener.run();
            }
        });
    }

    public void dispose() {
        this.myLoadingFinishedListeners.clear();
    }

    @Override
    @NotNull
    public T getCommitData(int hash, @NotNull Iterable<Integer> neighbourHashes) {
        assert (EventQueue.isDispatchThread());
        T details = this.getFromCache(hash);
        if (details != null) {
            return details;
        }
        this.runLoadCommitsData(neighbourHashes);
        T result2 = this.myCache.get(hash);
        assert (result2 != null);
        return result2;
    }

    @Override
    public void loadCommitsData(@NotNull List<Integer> hashes, @NotNull Consumer<? super List<T>> consumer, @NotNull Consumer<? super Throwable> errorConsumer, @Nullable ProgressIndicator indicator) {
        assert (EventQueue.isDispatchThread());
        this.loadCommitsData(AbstractDataGetter.getCommitsMap(hashes), consumer, errorConsumer, indicator);
    }

    private void loadCommitsData(final @NotNull TIntIntHashMap commits, final @NotNull Consumer<? super List<T>> consumer, final @NotNull Consumer<? super Throwable> errorConsumer, @Nullable ProgressIndicator indicator) {
        final ArrayList result2 = ContainerUtil.newArrayList();
        final TIntHashSet toLoad = new TIntHashSet();
        long taskNumber = this.myCurrentTaskIndex++;
        for (int id : commits.keys()) {
            T details = this.getFromCache(id);
            if (details == null || details instanceof LoadingDetails) {
                toLoad.add(id);
                this.cacheCommit(id, taskNumber);
                continue;
            }
            result2.add(details);
        }
        if (toLoad.isEmpty()) {
            this.sortCommitsByRow(result2, commits);
            consumer.consume((Object)result2);
        } else {
            Task.Backgroundable task2 = new Task.Backgroundable(null, "Loading Selected Details", true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull ProgressIndicator indicator) {
                    indicator.checkCanceled();
                    try {
                        TIntObjectHashMap map2 = AbstractDataGetter.this.preLoadCommitData(toLoad);
                        map2.forEachValue(value -> {
                            result2.add(value);
                            return true;
                        });
                        AbstractDataGetter.this.sortCommitsByRow(result2, commits);
                        AbstractDataGetter.this.notifyLoaded();
                    }
                    catch (VcsException e) {
                        LOG.warn((Throwable)e);
                        throw new RuntimeException(e);
                    }
                }

                public void onSuccess() {
                    consumer.consume((Object)result2);
                }

                public void onThrowable(@NotNull Throwable error) {
                    errorConsumer.consume((Object)error);
                }
            };
            if (indicator != null) {
                ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, indicator);
            } else {
                ProgressManager.getInstance().run((Task)task2);
            }
        }
    }

    private void sortCommitsByRow(@NotNull List<? extends T> result2, @NotNull TIntIntHashMap rowsForCommits) {
        ContainerUtil.sort(result2, (details1, details2) -> {
            int row1 = rowsForCommits.get(this.myStorage.getCommitIndex((Hash)details1.getId(), details1.getRoot()));
            int row2 = rowsForCommits.get(this.myStorage.getCommitIndex((Hash)details2.getId(), details2.getRoot()));
            return Comparing.compare((int)row1, (int)row2);
        });
    }

    @Override
    @Nullable
    public T getCommitDataIfAvailable(int hash) {
        return this.getFromCache(hash);
    }

    @Nullable
    private T getFromCache(@NotNull Integer commitId) {
        T details = this.myCache.get(commitId);
        if (details != null) {
            if (details instanceof LoadingDetails && ((LoadingDetails)details).getLoadingTaskIndex() <= this.myCurrentTaskIndex - 10L) {
                this.myCache.remove(commitId);
                return null;
            }
            return details;
        }
        return this.getFromAdditionalCache(commitId);
    }

    @Nullable
    protected abstract T getFromAdditionalCache(int var1);

    private void runLoadCommitsData(@NotNull Iterable<Integer> hashes) {
        long taskNumber = this.myCurrentTaskIndex++;
        TIntIntHashMap commits = AbstractDataGetter.getCommitsMap(hashes);
        TIntHashSet toLoad = new TIntHashSet();
        for (int id : commits.keys()) {
            this.cacheCommit(id, taskNumber);
            toLoad.add(id);
        }
        this.myLoader.queue(new TaskDescriptor(toLoad));
    }

    private void cacheCommit(int commitId, long taskNumber) {
        if (!this.myCache.isKeyCached(commitId)) {
            IndexDataGetter dataGetter = this.myIndex.getDataGetter();
            if (dataGetter != null) {
                this.myCache.put(commitId, new IndexedDetails(dataGetter, this.myStorage, commitId, taskNumber));
            } else {
                this.myCache.put(commitId, new LoadingDetails((Computable<? extends CommitId>)((Computable)() -> this.myStorage.getCommitId(commitId)), taskNumber));
            }
        }
    }

    @NotNull
    private static TIntIntHashMap getCommitsMap(@NotNull Iterable<Integer> hashes) {
        TIntIntHashMap commits = new TIntIntHashMap();
        int row2 = 0;
        for (Integer commitId : hashes) {
            commits.put(commitId.intValue(), row2);
            ++row2;
        }
        return commits;
    }

    @NotNull
    public TIntObjectHashMap<T> preLoadCommitData(@NotNull TIntHashSet commits) throws VcsException {
        TIntObjectHashMap result2 = new TIntObjectHashMap();
        MultiMap rootsAndHashes = MultiMap.create();
        commits.forEach(commit2 -> {
            CommitId commitId = this.myStorage.getCommitId(commit2);
            if (commitId != null) {
                rootsAndHashes.putValue((Object)commitId.getRoot(), (Object)commitId.getHash().asString());
            }
            return true;
        });
        for (Map.Entry entry : rootsAndHashes.entrySet()) {
            VcsLogProvider logProvider = this.myLogProviders.get(entry.getKey());
            if (logProvider != null) {
                List<T> details = this.readDetails(logProvider, (VirtualFile)entry.getKey(), ContainerUtil.newArrayList((Iterable)((Iterable)entry.getValue())));
                for (VcsShortCommitDetails data : details) {
                    int index = this.myStorage.getCommitIndex((Hash)data.getId(), data.getRoot());
                    result2.put(index, (Object)data);
                }
                this.saveInCache(result2);
                continue;
            }
            LOG.error("No log provider for root " + ((VirtualFile)entry.getKey()).getPath() + ". All known log providers " + this.myLogProviders);
        }
        return result2;
    }

    public void saveInCache(@NotNull TIntObjectHashMap<T> details) {
        UIUtil.invokeAndWaitIfNeeded(() -> details.forEachEntry((key, value) -> {
            this.myCache.put(key, (VcsShortCommitDetails)value);
            return true;
        }));
    }

    @NotNull
    protected abstract List<? extends T> readDetails(@NotNull VcsLogProvider var1, @NotNull VirtualFile var2, @NotNull List<String> var3) throws VcsException;

    public void addDetailsLoadedListener(@NotNull Runnable runnable2) {
        this.myLoadingFinishedListeners.add(runnable2);
    }

    public void removeDetailsLoadedListener(@NotNull Runnable runnable2) {
        this.myLoadingFinishedListeners.remove(runnable2);
    }

    private static class TaskDescriptor {
        @NotNull
        private final TIntHashSet myCommits;

        private TaskDescriptor(@NotNull TIntHashSet commits) {
            this.myCommits = commits;
        }
    }
}

