/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainingBranchesGetter {
    private static final Logger LOG = Logger.getInstance(ContainingBranchesGetter.class);
    @NotNull
    private final SequentialLimitedLifoExecutor<Task> myTaskExecutor;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final List<Runnable> myLoadingFinishedListeners = ContainerUtil.newArrayList();
    @NotNull
    private SLRUMap<CommitId, List<String>> myCache = ContainingBranchesGetter.createCache();
    @NotNull
    private Map<VirtualFile, Condition<Integer>> myConditions = ContainerUtil.newHashMap();
    private int myCurrentBranchesChecksum;

    ContainingBranchesGetter(@NotNull VcsLogData logData, @NotNull Disposable parentDisposable) {
        this.myLogData = logData;
        this.myTaskExecutor = new SequentialLimitedLifoExecutor(parentDisposable, 10, task2 -> {
            List<String> branches = task2.getContainingBranches(this.myLogData);
            ApplicationManager.getApplication().invokeLater(() -> {
                ((Task)task2).cache.put((Object)new CommitId(((Task)task2).hash, ((Task)task2).root), (Object)branches);
                this.notifyListeners();
            });
        });
        this.myLogData.addDataPackChangeListener(dataPack -> {
            Collection<VcsRef> currentBranches = dataPack.getRefsModel().getBranches();
            int checksum = currentBranches.hashCode();
            if (this.myCurrentBranchesChecksum != 0 && this.myCurrentBranchesChecksum != checksum) {
                this.clearCache();
            }
            this.myCurrentBranchesChecksum = checksum;
        });
    }

    private void clearCache() {
        this.myCache = ContainingBranchesGetter.createCache();
        this.myTaskExecutor.clear();
        this.myConditions = ContainerUtil.newHashMap();
        ApplicationManager.getApplication().invokeLater(this::notifyListeners);
    }

    public void addTaskCompletedListener(@NotNull Runnable runnable2) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.myLoadingFinishedListeners.add(runnable2);
    }

    public void removeTaskCompletedListener(@NotNull Runnable runnable2) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        this.myLoadingFinishedListeners.remove(runnable2);
    }

    private void notifyListeners() {
        LOG.assertTrue(EventQueue.isDispatchThread());
        for (Runnable listener2 : this.myLoadingFinishedListeners) {
            listener2.run();
        }
    }

    @Nullable
    public List<String> requestContainingBranches(@NotNull VirtualFile root, @NotNull Hash hash) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        List<String> refs = this.getContainingBranchesFromCache(root, hash);
        if (refs == null) {
            DataPack dataPack = this.myLogData.getDataPack();
            this.myTaskExecutor.queue(new Task(root, hash, this.myCache, dataPack.getPermanentGraph(), dataPack.getRefsModel()));
        }
        return refs;
    }

    @Nullable
    public List<String> getContainingBranchesFromCache(@NotNull VirtualFile root, @NotNull Hash hash) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        return (List)this.myCache.get((Object)new CommitId(hash, root));
    }

    @Nullable
    public List<String> getContainingBranchesQuickly(@NotNull VirtualFile root, @NotNull Hash hash) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        CommitId commitId = new CommitId(hash, root);
        List<String> branches = (List<String>)this.myCache.get((Object)commitId);
        if (branches == null) {
            int nodeId;
            int index = this.myLogData.getCommitIndex(hash, root);
            PermanentGraph<Integer> pg = this.myLogData.getDataPack().getPermanentGraph();
            if (pg instanceof PermanentGraphInfo && (branches = (nodeId = ((PermanentGraphInfo)pg).getPermanentCommitsInfo().getNodeId(index)) < 10000 && ContainingBranchesGetter.canUseGraphForComputation(this.myLogData.getLogProvider(root)) ? this.getContainingBranchesSynchronously(root, hash) : (List)BackgroundTaskUtil.tryComputeFast(indicator -> this.getContainingBranchesSynchronously(root, hash), 100L)) != null) {
                this.myCache.put((Object)commitId, branches);
            }
        }
        return branches;
    }

    @NotNull
    public Condition<Integer> getContainedInCurrentBranchCondition(@NotNull VirtualFile root) {
        LOG.assertTrue(EventQueue.isDispatchThread());
        Condition<Integer> condition = this.myConditions.get(root);
        if (condition == null) {
            condition = this.doGetContainedInCurrentBranchCondition(root);
            this.myConditions.put(root, condition);
        }
        return condition;
    }

    @NotNull
    private Condition<Integer> doGetContainedInCurrentBranchCondition(@NotNull VirtualFile root) {
        DataPack dataPack = this.myLogData.getDataPack();
        if (dataPack == DataPack.EMPTY) {
            return Conditions.alwaysFalse();
        }
        String branchName = this.myLogData.getLogProvider(root).getCurrentBranch(root);
        if (branchName == null) {
            return Conditions.alwaysFalse();
        }
        VcsRef branchRef = VcsLogUtil.findBranch(dataPack.getRefsModel(), root, branchName);
        if (branchRef == null) {
            return Conditions.alwaysFalse();
        }
        int branchIndex = this.myLogData.getCommitIndex(branchRef.getCommitHash(), branchRef.getRoot());
        return dataPack.getPermanentGraph().getContainedInBranchCondition(Collections.singleton(branchIndex));
    }

    @NotNull
    private static SLRUMap<CommitId, List<String>> createCache() {
        return new SLRUMap(1000, 1000);
    }

    @NotNull
    public List<String> getContainingBranchesSynchronously(@NotNull VirtualFile root, @NotNull Hash hash) {
        return this.doGetContainingBranches(this.myLogData.getDataPack(), root, hash);
    }

    @NotNull
    private List<String> doGetContainingBranches(@NotNull DataPack dataPack, @NotNull VirtualFile root, @NotNull Hash hash) {
        return new Task(root, hash, this.myCache, dataPack.getPermanentGraph(), dataPack.getRefsModel()).getContainingBranches(this.myLogData);
    }

    private static boolean canUseGraphForComputation(@NotNull VcsLogProvider logProvider) {
        return (Boolean)VcsLogProperties.get((VcsLogProvider)logProvider, (VcsLogProperties.VcsLogProperty)VcsLogProperties.LIGHTWEIGHT_BRANCHES);
    }

    private static class Task {
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final Hash hash;
        @NotNull
        private final SLRUMap<CommitId, List<String>> cache;
        @NotNull
        private final RefsModel refs;
        @NotNull
        private final PermanentGraph<Integer> graph;

        Task(@NotNull VirtualFile root, @NotNull Hash hash, @NotNull SLRUMap<CommitId, List<String>> cache, @NotNull PermanentGraph<Integer> graph2, @NotNull RefsModel refs) {
            this.root = root;
            this.hash = hash;
            this.cache = cache;
            this.graph = graph2;
            this.refs = refs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public List<String> getContainingBranches(@NotNull VcsLogData logData) {
            StopWatch sw = StopWatch.start("get containing branches");
            try {
                VcsLogProvider provider = logData.getLogProvider(this.root);
                if (ContainingBranchesGetter.canUseGraphForComputation(provider)) {
                    Set branchesIndexes = this.graph.getContainingBranches((Object)logData.getCommitIndex(this.hash, this.root));
                    Collection branchesRefs = new HashSet();
                    for (Integer index : branchesIndexes) {
                        this.refs.refsToCommit(index).stream().filter(ref -> ref.getType().isBranch()).forEach(branchesRefs::add);
                    }
                    branchesRefs = ContainerUtil.sorted(branchesRefs, (Comparator)provider.getReferenceManager().getLabelsOrderComparator());
                    ArrayList<String> branchesList = new ArrayList<String>();
                    for (VcsRef ref2 : branchesRefs) {
                        branchesList.add(ref2.getName());
                    }
                    ArrayList<String> arrayList = branchesList;
                    return arrayList;
                }
                ArrayList<String> branches = new ArrayList<String>(provider.getContainingBranches(this.root, this.hash));
                Collections.sort(branches);
                ArrayList<String> arrayList = branches;
                return arrayList;
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
                List<String> list2 = Collections.emptyList();
                return list2;
            }
            finally {
                sw.report();
            }
        }
    }
}

