/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.AbstractDataGetter;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsCommitCache;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.util.TroveUtil;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiniDetailsGetter
extends AbstractDataGetter<VcsCommitMetadata> {
    @NotNull
    private final TopCommitsCache myTopCommitsDetailsCache;
    @NotNull
    private final VcsLogObjectsFactory myFactory;

    MiniDetailsGetter(@NotNull Project project, @NotNull VcsLogStorage storage2, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull TopCommitsCache topCommitsDetailsCache, @NotNull VcsLogIndex index, @NotNull Disposable parentDisposable) {
        super(storage2, logProviders, new VcsCommitCache(), index, parentDisposable);
        this.myTopCommitsDetailsCache = topCommitsDetailsCache;
        this.myFactory = (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
    }

    @Override
    @Nullable
    protected VcsCommitMetadata getFromAdditionalCache(int commitId) {
        return this.myTopCommitsDetailsCache.get(commitId);
    }

    @Override
    @NotNull
    protected List<? extends VcsCommitMetadata> readDetails(@NotNull VcsLogProvider logProvider, @NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        return logProvider.readMetadata(root, hashes);
    }

    @Override
    @NotNull
    public TIntObjectHashMap<VcsCommitMetadata> preLoadCommitData(@NotNull TIntHashSet commits) throws VcsException {
        IndexDataGetter dataGetter = this.myIndex.getDataGetter();
        if (dataGetter == null) {
            return super.preLoadCommitData(commits);
        }
        TIntHashSet notIndexed = new TIntHashSet();
        TIntObjectHashMap<VcsCommitMetadata> result2 = TroveUtil.map2MapNotNull(commits, commit2 -> {
            VcsCommitMetadata metadata = IndexedDetails.createMetadata(commit2, dataGetter, this.myStorage, this.myFactory);
            if (metadata == null) {
                notIndexed.add(commit2);
            }
            return metadata;
        });
        this.saveInCache((TIntObjectHashMap)result2);
        if (!notIndexed.isEmpty()) {
            TroveUtil.putAll(result2, super.preLoadCommitData(notIndexed));
        }
        return result2;
    }
}

