/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SingleTaskController<Request, Result>
implements Disposable {
    private static final Logger LOG = Logger.getInstance(SingleTaskController.class);
    @NotNull
    private final String myName;
    @NotNull
    private final Consumer<? super Result> myResultHandler;
    @NotNull
    private final Object LOCK = new Object();
    private final boolean myCancelRunning;
    @NotNull
    private List<Request> myAwaitingRequests;
    @Nullable
    private SingleTask myRunningTask;
    private boolean myIsClosed = false;

    public SingleTaskController(@NotNull Project project, @NotNull String name, @NotNull Consumer<? super Result> handler2, boolean cancelRunning, @NotNull Disposable parent) {
        this.myName = name;
        this.myResultHandler = handler2;
        this.myAwaitingRequests = ContainerUtil.newLinkedList();
        this.myCancelRunning = cancelRunning;
        Disposer.register((Disposable)parent, (Disposable)this);
        VcsLogUtil.registerWithParentAndProject(parent, project, () -> this.closeQueue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void request(Request ... requests) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myIsClosed) {
                return;
            }
            this.myAwaitingRequests.addAll(Arrays.asList(requests));
            this.debug("Added requests: " + Arrays.toString(requests));
            if (this.myRunningTask != null && this.myCancelRunning) {
                this.cancelTask(this.myRunningTask);
            }
            if (this.myRunningTask == null) {
                this.myRunningTask = this.startNewBackgroundTask();
                this.debug("Started a new bg task " + this.myRunningTask);
            }
        }
    }

    private void debug(@NotNull String message) {
        LOG.debug("[" + this.myName + "] " + message);
    }

    private void cancelTask(@NotNull SingleTask t) {
        if (t.isRunning()) {
            t.cancel();
            this.debug("Canceled task " + this.myRunningTask);
        }
    }

    @NotNull
    protected abstract SingleTask startNewBackgroundTask();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Request> popRequests() {
        Object object = this.LOCK;
        synchronized (object) {
            List<Request> requests = this.myAwaitingRequests;
            this.myAwaitingRequests = ContainerUtil.newLinkedList();
            this.debug("Popped requests: " + requests);
            return requests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Request> peekRequests() {
        Object object = this.LOCK;
        synchronized (object) {
            ArrayList requests = ContainerUtil.newArrayList(this.myAwaitingRequests);
            this.debug("Peeked requests: " + requests);
            return requests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRequests(@NotNull List<Request> requests) {
        Object object = this.LOCK;
        synchronized (object) {
            this.myAwaitingRequests.removeAll(requests);
            this.debug("Removed requests: " + requests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Request popRequest() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myAwaitingRequests.isEmpty()) {
                return null;
            }
            Request request = this.myAwaitingRequests.remove(0);
            this.debug("Popped request: " + request);
            return request;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void taskCompleted(@Nullable Result result2) {
        if (result2 != null) {
            this.myResultHandler.consume(result2);
            this.debug("Handled result: " + result2);
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myAwaitingRequests.isEmpty()) {
                this.myRunningTask = null;
                this.debug("No more requests");
            } else {
                this.myRunningTask = this.startNewBackgroundTask();
                this.debug("Restarted a bg task " + this.myRunningTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeQueue() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myIsClosed) {
                return;
            }
            this.myIsClosed = true;
            if (this.myRunningTask != null) {
                this.myRunningTask.cancel();
            }
            this.myAwaitingRequests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        SingleTask task2 = null;
        Object object = this.LOCK;
        synchronized (object) {
            this.closeQueue();
            if (this.myRunningTask != null) {
                task2 = this.myRunningTask;
                this.myRunningTask = null;
            }
        }
        if (!ApplicationManager.getApplication().isDispatchThread() && task2 != null) {
            try {
                task2.waitFor(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.debug((Throwable)e);
            }
            catch (TimeoutException e) {
                LOG.warn("Wait time out ", (Throwable)e);
            }
        }
    }

    public static class SingleTaskImpl
    implements SingleTask {
        @NotNull
        private final Future<?> myFuture;
        @NotNull
        private final ProgressIndicator myIndicator;

        public SingleTaskImpl(@NotNull Future<?> future2, @NotNull ProgressIndicator indicator) {
            this.myFuture = future2;
            this.myIndicator = indicator;
        }

        @Override
        public void waitFor(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.myFuture.get(timeout, unit);
        }

        @Override
        public void cancel() {
            this.myIndicator.cancel();
        }

        @Override
        public boolean isRunning() {
            return this.myIndicator.isRunning();
        }
    }

    public static interface SingleTask {
        public void waitFor(long var1, @NotNull TimeUnit var3) throws InterruptedException, ExecutionException, TimeoutException;

        public void cancel();

        public boolean isRunning();
    }
}

