/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopCommitsCache {
    private static final Logger LOG = Logger.getInstance(TopCommitsCache.class);
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final IntObjectMap<VcsCommitMetadata> myCache = ContainerUtil.createConcurrentIntObjectMap();
    @NotNull
    private List<VcsCommitMetadata> mySortedDetails = ContainerUtil.newArrayList();

    public TopCommitsCache(@NotNull VcsLogStorage storage2) {
        this.myStorage = storage2;
    }

    private int getIndex(@NotNull VcsCommitMetadata metadata) {
        return this.myStorage.getCommitIndex((Hash)metadata.getId(), metadata.getRoot());
    }

    public void storeDetails(@NotNull List<? extends VcsCommitMetadata> sortedDetails) {
        List newDetails = ContainerUtil.filter(sortedDetails, metadata -> !this.myCache.containsValue(metadata));
        if (newDetails.isEmpty()) {
            return;
        }
        MergingIterator it = new MergingIterator(this.mySortedDetails, newDetails);
        ArrayList result2 = ContainerUtil.newArrayList();
        boolean isBroken = false;
        while (it.hasNext()) {
            VcsCommitMetadata detail = (VcsCommitMetadata)it.next();
            int index = this.getIndex(detail);
            if (index == -1) {
                isBroken = true;
                continue;
            }
            if (result2.size() < VcsLogData.RECENT_COMMITS_COUNT * 2) {
                result2.add(detail);
                this.myCache.put(index, (Object)detail);
                continue;
            }
            this.myCache.remove(index);
        }
        LOG.assertTrue(result2.size() == this.myCache.size() || isBroken, (Object)(result2.size() + " details to store, yet " + this.myCache.size() + " indexes in cache."));
        this.mySortedDetails = result2;
    }

    @Nullable
    public VcsCommitMetadata get(int index) {
        return (VcsCommitMetadata)this.myCache.get(index);
    }

    public void clear() {
        this.myCache.clear();
        this.mySortedDetails.clear();
    }

    private static class MergingIterator
    implements Iterator<VcsCommitMetadata> {
        private final PeekingIterator<VcsCommitMetadata> myFirst;
        private final PeekingIterator<VcsCommitMetadata> mySecond;

        private MergingIterator(@NotNull List<VcsCommitMetadata> first, @NotNull List<VcsCommitMetadata> second) {
            this.myFirst = Iterators.peekingIterator(first.iterator());
            this.mySecond = Iterators.peekingIterator(second.iterator());
        }

        @Override
        public boolean hasNext() {
            return this.myFirst.hasNext() || this.mySecond.hasNext();
        }

        @Override
        public VcsCommitMetadata next() {
            if (!this.myFirst.hasNext()) {
                return (VcsCommitMetadata)this.mySecond.next();
            }
            if (!this.mySecond.hasNext()) {
                return (VcsCommitMetadata)this.myFirst.next();
            }
            VcsCommitMetadata data1 = (VcsCommitMetadata)this.myFirst.peek();
            VcsCommitMetadata data2 = (VcsCommitMetadata)this.mySecond.peek();
            if (data1.getTimestamp() > data2.getTimestamp()) {
                return (VcsCommitMetadata)this.myFirst.next();
            }
            return (VcsCommitMetadata)this.mySecond.next();
        }
    }
}

