/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface VcsLogStorage {
    public int getCommitIndex(@NotNull Hash var1, @NotNull VirtualFile var2);

    @Nullable
    public CommitId getCommitId(int var1);

    public void iterateCommits(@NotNull Function<? super CommitId, Boolean> var1);

    public boolean containsCommit(@NotNull CommitId var1);

    @Nullable
    default public CommitId findCommitId(@NotNull Condition<? super CommitId> condition) {
        Ref hashRef = Ref.create();
        this.iterateCommits((Function<? super CommitId, Boolean>)((Function)commitId -> {
            boolean matches = condition.value(commitId);
            if (matches) {
                hashRef.set(commitId);
            }
            return matches;
        }));
        return (CommitId)hashRef.get();
    }

    public int getRefIndex(@NotNull VcsRef var1);

    @Nullable
    public VcsRef getVcsRef(int var1);

    public void flush();
}

