/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class VcsLogStructureFilterImpl
implements VcsLogDetailsFilter,
VcsLogStructureFilter {
    @NotNull
    private final Collection<FilePath> myFiles;

    @Deprecated
    public VcsLogStructureFilterImpl(@NotNull Collection<FilePath> files2) {
        this.myFiles = files2;
    }

    @NotNull
    public Collection<FilePath> getFiles() {
        return this.myFiles;
    }

    public boolean matches(@NotNull VcsCommitMetadata details) {
        if (details instanceof VcsFullCommitDetails) {
            for (Change change : ((VcsFullCommitDetails)details).getChanges()) {
                ContentRevision before = change.getBeforeRevision();
                if (before != null && this.matches(before.getFile().getPath())) {
                    return true;
                }
                ContentRevision after = change.getAfterRevision();
                if (after == null || !this.matches(after.getFile().getPath())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(@NotNull String path) {
        return ContainerUtil.find(this.myFiles, file2 -> FileUtil.isAncestor((String)file2.getPath(), (String)path, (boolean)false)) != null;
    }

    public String toString() {
        return "files:" + this.myFiles;
    }
}

