/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.history.FileNamesData;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.util.TroveUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogMultiplePatternsTextFilter;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexDataGetter {
    private static final Logger LOG = Logger.getInstance(IndexDataGetter.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<? extends VirtualFile> myRoots;
    @NotNull
    private final VcsLogPersistentIndex.IndexStorage myIndexStorage;
    @NotNull
    private final VcsLogStorage myLogStorage;
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;

    public IndexDataGetter(@NotNull Project project, @NotNull Set<? extends VirtualFile> roots, @NotNull VcsLogPersistentIndex.IndexStorage indexStorage, @NotNull VcsLogStorage logStorage, @NotNull FatalErrorHandler fatalErrorsConsumer) {
        this.myProject = project;
        this.myRoots = roots;
        this.myIndexStorage = indexStorage;
        this.myLogStorage = logStorage;
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
    }

    @Nullable
    public VcsUser getAuthor(int commit2) {
        return (VcsUser)this.executeAndCatch(() -> this.myIndexStorage.users.getAuthorForCommit(commit2));
    }

    @Nullable
    public VcsUser getCommitter(int commit2) {
        return (VcsUser)this.executeAndCatch(() -> {
            Integer committer = (Integer)this.myIndexStorage.committers.get((Object)commit2);
            if (committer != null) {
                return this.myIndexStorage.users.getUserById(committer);
            }
            if (this.myIndexStorage.commits.contains(commit2)) {
                return this.myIndexStorage.users.getAuthorForCommit(commit2);
            }
            return null;
        });
    }

    @Nullable
    public Long getAuthorTime(int commit2) {
        return (Long)this.executeAndCatch(() -> {
            Pair time = (Pair)this.myIndexStorage.timestamps.get((Object)commit2);
            if (time == null) {
                return null;
            }
            return (Long)time.first;
        });
    }

    @Nullable
    public Long getCommitTime(int commit2) {
        return (Long)this.executeAndCatch(() -> {
            Pair time = (Pair)this.myIndexStorage.timestamps.get((Object)commit2);
            if (time == null) {
                return null;
            }
            return (Long)time.second;
        });
    }

    @Nullable
    public String getFullMessage(int index) {
        return (String)this.executeAndCatch(() -> (String)this.myIndexStorage.messages.get((Object)index));
    }

    @Nullable
    public List<Hash> getParents(int index) {
        return (List)this.executeAndCatch(() -> {
            List parentsIndexes = (List)this.myIndexStorage.parents.get((Object)index);
            if (parentsIndexes == null) {
                return null;
            }
            ArrayList result2 = ContainerUtil.newArrayList();
            Iterator iterator = parentsIndexes.iterator();
            while (iterator.hasNext()) {
                int parentIndex = (Integer)iterator.next();
                CommitId id = this.myLogStorage.getCommitId(parentIndex);
                if (id == null) {
                    return null;
                }
                result2.add(id.getHash());
            }
            return result2;
        });
    }

    @NotNull
    public Set<FilePath> getChangedPaths(int commit2) {
        List<Hash> parents = this.getParents(commit2);
        if (parents == null || parents.size() > 1) {
            return Collections.emptySet();
        }
        return this.getChangedPaths(commit2, 0);
    }

    @NotNull
    public Set<FilePath> getChangedPaths(int commit2, int parentIndex) {
        return this.executeAndCatch(() -> this.myIndexStorage.paths.getPathsChangedInCommit(commit2, parentIndex), Collections.emptySet());
    }

    public boolean canFilter(@NotNull List<VcsLogDetailsFilter> filters) {
        if (filters.isEmpty()) {
            return false;
        }
        return ContainerUtil.all(filters, filter -> {
            if (filter instanceof VcsLogTextFilter || filter instanceof VcsLogUserFilter) {
                return true;
            }
            if (filter instanceof VcsLogStructureFilter) {
                Collection files2 = ((VcsLogStructureFilter)filter).getFiles();
                return ContainerUtil.find((Iterable)files2, file2 -> file2.isDirectory() && this.myRoots.contains(file2.getVirtualFile())) == null;
            }
            return false;
        });
    }

    @NotNull
    public Set<Integer> filter(@NotNull List<VcsLogDetailsFilter> detailsFilters) {
        VcsLogTextFilter textFilter = (VcsLogTextFilter)ContainerUtil.findInstance(detailsFilters, VcsLogTextFilter.class);
        VcsLogUserFilter userFilter = (VcsLogUserFilter)ContainerUtil.findInstance(detailsFilters, VcsLogUserFilter.class);
        VcsLogStructureFilter pathFilter = (VcsLogStructureFilter)ContainerUtil.findInstance(detailsFilters, VcsLogStructureFilter.class);
        TIntHashSet filteredByMessage = null;
        if (textFilter != null) {
            filteredByMessage = this.filterMessages(textFilter);
        }
        TIntHashSet filteredByUser = null;
        if (userFilter != null) {
            HashSet users = ContainerUtil.newHashSet();
            for (VirtualFile virtualFile : this.myRoots) {
                users.addAll(userFilter.getUsers(virtualFile));
            }
            filteredByUser = this.filterUsers(users);
        }
        TIntHashSet filteredByPath = null;
        if (pathFilter != null) {
            filteredByPath = this.filterPaths(pathFilter.getFiles());
        }
        return TroveUtil.intersect(filteredByMessage, filteredByPath, filteredByUser);
    }

    @NotNull
    private TIntHashSet filterUsers(@NotNull Set<? extends VcsUser> users) {
        return this.executeAndCatch(() -> this.myIndexStorage.users.getCommitsForUsers(users), new TIntHashSet());
    }

    @NotNull
    private TIntHashSet filterPaths(@NotNull Collection<? extends FilePath> paths) {
        return this.executeAndCatch(() -> {
            TIntHashSet result2 = new TIntHashSet();
            for (FilePath path : paths) {
                Set<Integer> commits = this.createFileNamesData(path).getCommits();
                if (commits.isEmpty() && !path.isDirectory()) {
                    commits = this.createFileNamesData(VcsUtil.getFilePath((String)path.getPath(), (boolean)true)).getCommits();
                }
                TroveUtil.addAll(result2, commits);
            }
            return result2;
        }, new TIntHashSet());
    }

    @NotNull
    private TIntHashSet filterMessages(@NotNull VcsLogTextFilter filter) {
        TIntHashSet resultByTrigrams;
        if ((!filter.isRegex() || filter instanceof VcsLogMultiplePatternsTextFilter) && (resultByTrigrams = (TIntHashSet)this.executeAndCatch(() -> {
            List<String> trigramSources = filter instanceof VcsLogMultiplePatternsTextFilter ? ((VcsLogMultiplePatternsTextFilter)filter).getPatterns() : Collections.singletonList(filter.getText());
            TIntHashSet commitsForSearch = new TIntHashSet();
            for (String string : trigramSources) {
                TIntHashSet commits = this.myIndexStorage.trigrams.getCommitsForSubstring(string);
                if (commits == null) {
                    return null;
                }
                TroveUtil.addAll(commitsForSearch, commits);
            }
            TIntHashSet result2 = new TIntHashSet();
            commitsForSearch.forEach(commit2 -> {
                try {
                    String value = (String)this.myIndexStorage.messages.get((Object)commit2);
                    if (value != null && filter.matches(value)) {
                        result2.add(commit2);
                    }
                }
                catch (IOException e) {
                    this.myFatalErrorsConsumer.consume(this, e);
                    return false;
                }
                return true;
            });
            return result2;
        })) != null) {
            return resultByTrigrams;
        }
        return this.filter(this.myIndexStorage.messages, arg_0 -> ((VcsLogTextFilter)filter).matches(arg_0));
    }

    @NotNull
    private <T> TIntHashSet filter(@NotNull PersistentMap<Integer, T> map2, @NotNull Condition<? super T> condition) {
        TIntHashSet result2 = new TIntHashSet();
        return this.executeAndCatch(() -> {
            IndexDataGetter.processKeys(map2, (Processor<Integer>)((Processor)commit2 -> {
                try {
                    Object value = map2.get(commit2);
                    if (value != null && condition.value(value)) {
                        result2.add(commit2.intValue());
                    }
                }
                catch (IOException e) {
                    this.myFatalErrorsConsumer.consume(this, e);
                    return false;
                }
                return true;
            }));
            return result2;
        }, result2);
    }

    @NotNull
    public Set<FilePath> getKnownNames(@NotNull FilePath path) {
        return this.executeAndCatch(() -> this.createFileNamesData(path).getFiles(), Collections.emptySet());
    }

    @NotNull
    public TIntObjectHashMap<TIntObjectHashMap<VcsLogPathsIndex.ChangeKind>> getAffectedCommits(@NotNull FilePath path) {
        TIntObjectHashMap affectedCommits = new TIntObjectHashMap();
        VirtualFile root = VcsLogUtil.getActualRoot(this.myProject, path);
        if (this.myRoots.contains(root)) {
            this.executeAndCatch(() -> {
                this.myIndexStorage.paths.iterateCommits(path, (changes2, commit2) -> this.executeAndCatch(() -> {
                    List parents = (List)this.myIndexStorage.parents.get((Object)commit2);
                    if (parents == null) {
                        throw new CorruptedDataException("No parents for commit " + commit2);
                    }
                    TIntObjectHashMap changesMap = new TIntObjectHashMap();
                    if (parents.size() == 0 && !changes2.isEmpty()) {
                        changesMap.put(commit2, ContainerUtil.getFirstItem((List)changes2));
                    } else {
                        LOG.assertTrue(parents.size() == changes2.size(), (Object)("Commit " + commit2 + " has " + parents.size() + " parents, but " + changes2.size() + " changes."));
                        for (Pair parentAndChanges : ContainerUtil.zip((Iterable)parents, (Iterable)changes2)) {
                            changesMap.put(((Integer)parentAndChanges.first).intValue(), parentAndChanges.second);
                        }
                    }
                    affectedCommits.put(commit2, (Object)changesMap);
                    return null;
                }));
                return null;
            });
        }
        return affectedCommits;
    }

    @Nullable
    public Couple<FilePath> findRename(int parent, int child2, @NotNull BooleanFunction<? super Couple<FilePath>> accept2) {
        return (Couple)this.executeAndCatch(() -> this.myIndexStorage.paths.iterateRenames(parent, child2, accept2));
    }

    @NotNull
    public FileNamesData createFileNamesData(@NotNull FilePath path) {
        return this.createFileNamesData(Collections.singletonList(path));
    }

    @NotNull
    public FileNamesData createFileNamesData(@NotNull Collection<FilePath> paths) {
        return new FileNamesData(paths){

            @Override
            @NotNull
            public TIntObjectHashMap<TIntObjectHashMap<VcsLogPathsIndex.ChangeKind>> getAffectedCommits(@NotNull FilePath path) {
                return IndexDataGetter.this.getAffectedCommits(path);
            }

            @Override
            @Nullable
            public Couple<FilePath> findRename(int parent, int child2, @NotNull Function1<? super Couple<FilePath>, Boolean> accept2) {
                return IndexDataGetter.this.findRename(parent, child2, (BooleanFunction<? super Couple<FilePath>>)((BooleanFunction)couple -> (Boolean)accept2.invoke(couple)));
            }
        };
    }

    @NotNull
    public VcsLogStorage getLogStorage() {
        return this.myLogStorage;
    }

    private static <T> void processKeys(@NotNull PersistentMap<Integer, T> map2, @NotNull Processor<Integer> processor2) throws IOException {
        if (map2 instanceof PersistentHashMap) {
            ((PersistentHashMap)map2).processKeysWithExistingMapping(processor2);
        } else {
            map2.processKeys(processor2);
        }
    }

    @Nullable
    private <T> T executeAndCatch(@NotNull Throwable2Computable<T, IOException, StorageException> computable) {
        return this.executeAndCatch(computable, null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    private <T> T executeAndCatch(@NotNull Throwable2Computable<? extends T, IOException, StorageException> computable, @Nullable T defaultValue) {
        try {
            return (T)computable.compute();
        }
        catch (StorageException | CorruptedDataException | IOException e) {
            this.myIndexStorage.markCorrupted();
            this.myFatalErrorsConsumer.consume(this, e);
        }
        catch (RuntimeException e) {
            this.processRuntimeException(e);
        }
        return defaultValue;
    }

    private void processRuntimeException(@NotNull RuntimeException e) {
        if (e instanceof ProcessCanceledException) {
            throw e;
        }
        this.myIndexStorage.markCorrupted();
        if (!(e.getCause() instanceof IOException) && !(e.getCause() instanceof StorageException)) {
            throw new RuntimeException(e);
        }
        this.myFatalErrorsConsumer.consume(this, e);
    }

    private static class CorruptedDataException
    extends RuntimeException {
        CorruptedDataException(@NotNull String message) {
            super(message);
        }
    }
}

