/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.EmptyInputDataDiffBuilder;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapBasedForwardIndex;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.util.StorageId;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFullDetailsIndex<T, D extends VcsFullCommitDetails>
implements Disposable {
    protected static final String INDEX = "index";
    @NotNull
    protected final MyMapReduceIndex myMapReduceIndex;
    @NotNull
    protected final StorageId myStorageId;
    @NotNull
    protected final String myName;
    @NotNull
    protected final DataIndexer<Integer, T, D> myIndexer;
    @NotNull
    private final FatalErrorHandler myFatalErrorHandler;
    private volatile boolean myDisposed = false;

    public VcsLogFullDetailsIndex(@NotNull StorageId storageId, @NotNull String name, @NotNull DataIndexer<Integer, T, D> indexer, @NotNull DataExternalizer<T> externalizer, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        this.myName = name;
        this.myStorageId = storageId;
        this.myIndexer = indexer;
        this.myFatalErrorHandler = fatalErrorHandler;
        this.myMapReduceIndex = this.createMapReduceIndex(externalizer);
        Disposer.register((Disposable)disposableParent, (Disposable)this);
    }

    @NotNull
    private MyMapReduceIndex createMapReduceIndex(@NotNull DataExternalizer<T> dataExternalizer) throws IOException {
        MyIndexExtension<T, D> extension = new MyIndexExtension<T, D>(this.myName, this.myIndexer, dataExternalizer, this.myStorageId.getVersion());
        ForwardIndex<Integer, T> forwardIndex = this.createForwardIndex(extension);
        return new MyMapReduceIndex(extension, new MyMapIndexStorage<T>(this.myName, this.myStorageId, dataExternalizer), forwardIndex);
    }

    @NotNull
    protected ForwardIndex<Integer, T> createForwardIndex(@NotNull IndexExtension<Integer, T, D> extension) throws IOException {
        return new EmptyForwardIndex();
    }

    @NotNull
    public TIntHashSet getCommitsWithAnyKey(@NotNull Set<Integer> keys) throws StorageException {
        this.checkDisposed();
        TIntHashSet result2 = new TIntHashSet();
        for (Integer key : keys) {
            this.iterateCommitIds(key, (Consumer<Integer>)((Consumer)arg_0 -> ((TIntHashSet)result2).add(arg_0)));
        }
        return result2;
    }

    @NotNull
    public TIntHashSet getCommitsWithAllKeys(@NotNull Collection<Integer> keys) throws StorageException {
        this.checkDisposed();
        return InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)this.myMapReduceIndex, keys, k -> {
            ProgressManager.checkCanceled();
            return true;
        }, null, null);
    }

    private void iterateCommitIds(int key, @NotNull Consumer<Integer> consumer) throws StorageException {
        ValueContainer data = this.myMapReduceIndex.getData(key);
        data.forEach((id, value) -> {
            consumer.consume((Object)id);
            return true;
        });
    }

    protected void iterateCommitIdsAndValues(int key, @NotNull ObjIntConsumer<? super T> consumer) throws StorageException {
        this.myMapReduceIndex.getData(key).forEach((id, value) -> {
            consumer.accept(value, id);
            return true;
        });
    }

    @Nullable
    protected <MapIndexType> MapIndexType getKeysForCommit(int commit2) throws IOException {
        MapBasedForwardIndex index = this.myMapReduceIndex.getForwardIndex();
        if (index == null) {
            return null;
        }
        return (MapIndexType)index.getInput(commit2);
    }

    public void update(int commitId, @NotNull D details) {
        this.checkDisposed();
        this.myMapReduceIndex.update(commitId, details).compute();
    }

    public void flush() throws StorageException {
        this.checkDisposed();
        this.myMapReduceIndex.flush();
    }

    public void dispose() {
        this.myDisposed = true;
        this.myMapReduceIndex.dispose();
    }

    private void checkDisposed() {
        if (this.myDisposed) {
            throw new ProcessCanceledException();
        }
    }

    private static class EmptyForwardIndex<T>
    implements ForwardIndex<Integer, T> {
        private EmptyForwardIndex() {
        }

        @NotNull
        public InputDataDiffBuilder<Integer, T> getDiffBuilder(int inputId) {
            return new EmptyInputDataDiffBuilder(inputId);
        }

        public void putInputData(int inputId, @NotNull Map<Integer, T> data) {
        }

        public void flush() {
        }

        public void clear() {
        }

        public void close() {
        }
    }

    private static class MyIndexExtension<T, D>
    extends IndexExtension<Integer, T, D> {
        @NotNull
        private final IndexId<Integer, T> myID;
        @NotNull
        private final DataIndexer<Integer, T, D> myIndexer;
        @NotNull
        private final DataExternalizer<T> myExternalizer;
        private final int myVersion;

        MyIndexExtension(@NotNull String name, @NotNull DataIndexer<Integer, T, D> indexer, @NotNull DataExternalizer<T> externalizer, int version2) {
            this.myID = IndexId.create((String)name);
            this.myIndexer = indexer;
            this.myExternalizer = externalizer;
            this.myVersion = version2;
        }

        @NotNull
        public IndexId<Integer, T> getName() {
            return this.myID;
        }

        @NotNull
        public DataIndexer<Integer, T, D> getIndexer() {
            return this.myIndexer;
        }

        @NotNull
        public KeyDescriptor<Integer> getKeyDescriptor() {
            return EnumeratorIntegerDescriptor.INSTANCE;
        }

        @NotNull
        public DataExternalizer<T> getValueExternalizer() {
            return this.myExternalizer;
        }

        public int getVersion() {
            return this.myVersion;
        }
    }

    private static class MyMapIndexStorage<T>
    extends MapIndexStorage<Integer, T> {
        MyMapIndexStorage(@NotNull String name, @NotNull StorageId storageId, @NotNull DataExternalizer<T> externalizer) throws IOException {
            super(storageId.getStorageFile(name, true), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, externalizer, 5000, false);
        }

        protected void checkCanceled() {
            ProgressManager.checkCanceled();
        }
    }

    private class MyMapReduceIndex
    extends MapReduceIndex<Integer, T, D> {
        MyMapReduceIndex(@NotNull MyIndexExtension<T, D> extension, @NotNull MyMapIndexStorage<T> mapIndexStorage, ForwardIndex<Integer, T> forwardIndex) {
            super(extension, mapIndexStorage, forwardIndex);
        }

        @Nullable
        public <MapIndexType> MapBasedForwardIndex<Integer, T, MapIndexType> getForwardIndex() {
            if (this.myForwardIndex instanceof MapBasedForwardIndex) {
                return (MapBasedForwardIndex)this.myForwardIndex;
            }
            return null;
        }

        public void checkCanceled() {
            ProgressManager.checkCanceled();
        }

        public void requestRebuild(@NotNull Throwable ex) {
            VcsLogFullDetailsIndex.this.myFatalErrorHandler.consume((Object)this, ex);
        }
    }
}

