/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.MapBasedForwardIndex;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.impl.VcsIndexableDetails;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogPathsForwardIndex
extends MapBasedForwardIndex<Integer, List<VcsLogPathsIndex.ChangeKind>, List<Collection<Integer>>> {
    protected VcsLogPathsForwardIndex(@NotNull IndexExtension<Integer, List<VcsLogPathsIndex.ChangeKind>, VcsIndexableDetails> extension) throws IOException {
        super(extension);
    }

    protected InputDataDiffBuilder<Integer, List<VcsLogPathsIndex.ChangeKind>> getDiffBuilder(int inputId, @Nullable List<Collection<Integer>> oldData) {
        return new VcsLogPathsDiffBuilder(inputId, oldData);
    }

    protected List<Collection<Integer>> convertToMapValueType(int inputId, @NotNull Map<Integer, List<VcsLogPathsIndex.ChangeKind>> map2) {
        return VcsLogPathsForwardIndex.convertToMapValueType(map2);
    }

    @NotNull
    static List<Collection<Integer>> convertToMapValueType(@NotNull Map<Integer, List<VcsLogPathsIndex.ChangeKind>> map2) {
        SmartList result2 = new SmartList();
        for (Map.Entry<Integer, List<VcsLogPathsIndex.ChangeKind>> entry : map2.entrySet()) {
            Integer fileId = entry.getKey();
            List<VcsLogPathsIndex.ChangeKind> changes2 = entry.getValue();
            while (result2.size() < changes2.size()) {
                result2.add((Object)ContainerUtil.newHashSet());
            }
            for (int i = 0; i < changes2.size(); ++i) {
                if (changes2.get(i) == VcsLogPathsIndex.ChangeKind.NOT_CHANGED) continue;
                ((Collection)result2.get(i)).add(fileId);
            }
        }
        return result2;
    }

    static class VcsLogPathsDiffBuilder
    extends InputDataDiffBuilder<Integer, List<VcsLogPathsIndex.ChangeKind>> {
        @Nullable
        private final List<? extends Collection<Integer>> myOldData;

        VcsLogPathsDiffBuilder(int id, @Nullable List<? extends Collection<Integer>> oldData) {
            super(id);
            this.myOldData = oldData;
        }

        public boolean differentiate(@NotNull Map<Integer, List<VcsLogPathsIndex.ChangeKind>> newData, @NotNull KeyValueUpdateProcessor<? super Integer, ? super List<VcsLogPathsIndex.ChangeKind>> addProcessor, @NotNull KeyValueUpdateProcessor<? super Integer, ? super List<VcsLogPathsIndex.ChangeKind>> updateProcessor, @NotNull RemovedKeyProcessor<? super Integer> removeProcessor) throws StorageException {
            if (this.myOldData == null) {
                return this.processNewFiles(newData, addProcessor);
            }
            Map newFiles = ContainerUtil.filter(newData, it -> !this.isFileInOldData((Integer)it));
            return this.processNewFiles(newFiles, addProcessor);
        }

        public boolean processNewFiles(@NotNull Map<Integer, List<VcsLogPathsIndex.ChangeKind>> newData, @NotNull KeyValueUpdateProcessor<? super Integer, ? super List<VcsLogPathsIndex.ChangeKind>> addProcessor) throws StorageException {
            for (Map.Entry<Integer, List<VcsLogPathsIndex.ChangeKind>> entry : newData.entrySet()) {
                addProcessor.process((Object)entry.getKey(), entry.getValue(), this.myInputId);
            }
            return !newData.isEmpty();
        }

        private boolean isFileInOldData(@NotNull Integer fileId) {
            if (this.myOldData == null) {
                return false;
            }
            return ContainerUtil.find(this.myOldData, files2 -> files2.contains(fileId)) != null;
        }
    }

    public static class IntCollectionListExternalizer
    implements DataExternalizer<List<Collection<Integer>>> {
        public void save(@NotNull DataOutput out, @NotNull List<Collection<Integer>> value) throws IOException {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
            for (Collection<Integer> collection : value) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)collection.size());
                for (int i : collection) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)i);
                }
            }
        }

        @NotNull
        public List<Collection<Integer>> read(@NotNull DataInput in) throws IOException {
            SmartList result2 = new SmartList();
            int listSize = DataInputOutputUtil.readINT((DataInput)in);
            for (int i = 0; i < listSize; ++i) {
                HashSet collection = ContainerUtil.newHashSet();
                result2.add((Object)collection);
                int collectionSize = DataInputOutputUtil.readINT((DataInput)in);
                for (int j = 0; j < collectionSize; ++j) {
                    collection.add(DataInputOutputUtil.readINT((DataInput)in));
                }
            }
            return result2;
        }
    }
}

