/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogIndexService;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.data.index.VcsLogPathsForwardIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.VcsIndexableDetails;
import com.intellij.vcs.log.util.StorageId;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TByteObjectHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogPathsIndex
extends VcsLogFullDetailsIndex<List<ChangeKind>, VcsIndexableDetails> {
    private static final Logger LOG = Logger.getInstance(VcsLogPathsIndex.class);
    public static final String PATHS = "paths";
    public static final String INDEX_PATHS_IDS = "paths-ids";
    public static final String RENAMES_MAP = "renames-map";
    @NotNull
    private final PathsIndexer myPathsIndexer;

    public VcsLogPathsIndex(@NotNull StorageId storageId, @NotNull VcsLogStorage storage2, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        super(storageId, PATHS, new PathsIndexer(storage2, VcsLogPathsIndex.createPathsEnumerator(storageId), VcsLogPathsIndex.createRenamesMap(storageId)), new ChangeKindListKeyDescriptor(), fatalErrorHandler, disposableParent);
        this.myPathsIndexer = (PathsIndexer)this.myIndexer;
        this.myPathsIndexer.setFatalErrorConsumer((Consumer<? super Exception>)((Consumer)e -> fatalErrorHandler.consume(this, (Throwable)e)));
    }

    @Override
    @NotNull
    protected ForwardIndex<Integer, List<ChangeKind>> createForwardIndex(@NotNull IndexExtension<Integer, List<ChangeKind>, VcsIndexableDetails> extension) throws IOException {
        if (!VcsLogIndexService.isPathsForwardIndexRequired()) {
            return super.createForwardIndex(extension);
        }
        return new VcsLogPathsForwardIndex(extension){

            @NotNull
            public PersistentHashMap<Integer, List<Collection<Integer>>> createMap() throws IOException {
                File storageFile = VcsLogPathsIndex.this.myStorageId.getStorageFile(VcsLogPathsIndex.this.myName + ".idx");
                return new PersistentHashMap(storageFile, (KeyDescriptor)new IntInlineKeyDescriptor(), (DataExternalizer)new VcsLogPathsForwardIndex.IntCollectionListExternalizer(), Page.PAGE_SIZE);
            }
        };
    }

    @NotNull
    private static PersistentEnumeratorBase<LightFilePath> createPathsEnumerator(@NotNull StorageId storageId) throws IOException {
        File storageFile = storageId.getStorageFile(INDEX_PATHS_IDS);
        return new PersistentBTreeEnumerator(storageFile, (KeyDescriptor)new LightFilePathKeyDescriptor(), Page.PAGE_SIZE, null, storageId.getVersion());
    }

    @NotNull
    private static PersistentHashMap<Couple<Integer>, Collection<Couple<Integer>>> createRenamesMap(@NotNull StorageId storageId) throws IOException {
        File storageFile = storageId.getStorageFile(RENAMES_MAP);
        return new PersistentHashMap(storageFile, (KeyDescriptor)new CoupleKeyDescriptor(), (DataExternalizer)new CollectionDataExternalizer(), Page.PAGE_SIZE, storageId.getVersion());
    }

    @Nullable
    public FilePath getPath(int pathId) {
        try {
            return VcsLogPathsIndex.toFilePath((LightFilePath)this.myPathsIndexer.getPathsEnumerator().valueOf(pathId));
        }
        catch (IOException e) {
            this.myPathsIndexer.myFatalErrorConsumer.consume((Object)e);
            return null;
        }
    }

    @Override
    public void flush() throws StorageException {
        super.flush();
        this.myPathsIndexer.myRenamesMap.force();
        this.myPathsIndexer.getPathsEnumerator().force();
    }

    @Nullable
    public Couple<FilePath> iterateRenames(int parent, int child2, @NotNull BooleanFunction<? super Couple<FilePath>> accept2) throws IOException {
        Collection renames = (Collection)this.myPathsIndexer.myRenamesMap.get((Object)Couple.of((Object)parent, (Object)child2));
        if (renames == null) {
            return null;
        }
        for (Couple rename : renames) {
            FilePath path2;
            FilePath path1 = this.getPath((Integer)rename.first);
            Couple paths = Couple.of((Object)path1, (Object)(path2 = this.getPath((Integer)rename.second)));
            if (!accept2.fun((Object)paths)) continue;
            return paths;
        }
        return null;
    }

    @NotNull
    public Set<FilePath> getPathsChangedInCommit(int commit2, int parentIndex) throws IOException {
        List keysForCommit = (List)this.getKeysForCommit(commit2);
        if (keysForCommit == null || keysForCommit.size() <= parentIndex) {
            return Collections.emptySet();
        }
        HashSet paths = ContainerUtil.newHashSet();
        for (Integer pathId : ContainerUtil.newHashSet((Iterable)((Iterable)keysForCommit.get(parentIndex)))) {
            LightFilePath lightFilePath = (LightFilePath)this.myPathsIndexer.getPathsEnumerator().valueOf(pathId.intValue());
            if (lightFilePath.isDirectory()) continue;
            paths.add(VcsLogPathsIndex.toFilePath(lightFilePath));
        }
        return paths;
    }

    public void iterateCommits(@NotNull FilePath path, @NotNull ObjIntConsumer<? super List<ChangeKind>> consumer) throws IOException, StorageException {
        int pathId = this.myPathsIndexer.myPathsEnumerator.enumerate((Object)new LightFilePath(path));
        this.iterateCommitIdsAndValues(pathId, consumer);
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.myPathsIndexer.myRenamesMap.close();
            this.myPathsIndexer.getPathsEnumerator().close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    private static FilePath toFilePath(@Nullable LightFilePath lightFilePath) {
        if (lightFilePath == null) {
            return null;
        }
        return VcsUtil.getFilePath((String)lightFilePath.getPath(), (boolean)lightFilePath.isDirectory());
    }

    static /* synthetic */ Logger access$900() {
        return LOG;
    }

    private static class CollectionDataExternalizer
    implements DataExternalizer<Collection<Couple<Integer>>> {
        private CollectionDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, Collection<Couple<Integer>> value) throws IOException {
            out.writeInt(value.size());
            for (Couple<Integer> v : value) {
                out.writeInt((Integer)v.first);
                out.writeInt((Integer)v.second);
            }
        }

        public Collection<Couple<Integer>> read(@NotNull DataInput in) throws IOException {
            SmartList result2 = new SmartList();
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                result2.add(Couple.of((Object)in.readInt(), (Object)in.readInt()));
            }
            return result2;
        }
    }

    private static class CoupleKeyDescriptor
    implements KeyDescriptor<Couple<Integer>> {
        private CoupleKeyDescriptor() {
        }

        public int getHashCode(Couple<Integer> value) {
            return value.hashCode();
        }

        public boolean isEqual(Couple<Integer> val1, Couple<Integer> val2) {
            return val1.equals(val2);
        }

        public void save(@NotNull DataOutput out, Couple<Integer> value) throws IOException {
            out.writeInt((Integer)value.first);
            out.writeInt((Integer)value.second);
        }

        public Couple<Integer> read(@NotNull DataInput in) throws IOException {
            return Couple.of((Object)in.readInt(), (Object)in.readInt());
        }
    }

    private static class LightFilePathKeyDescriptor
    implements KeyDescriptor<LightFilePath> {
        private LightFilePathKeyDescriptor() {
        }

        public int getHashCode(LightFilePath path) {
            return path.hashCode();
        }

        public boolean isEqual(LightFilePath path1, LightFilePath path2) {
            return path1.equals(path2);
        }

        public void save(@NotNull DataOutput out, LightFilePath value) throws IOException {
            IOUtil.writeUTF((DataOutput)out, (String)value.getPath());
            out.writeBoolean(value.myIsDirectory);
        }

        public LightFilePath read(@NotNull DataInput in) throws IOException {
            String path = IOUtil.readUTF((DataInput)in);
            boolean isDirectory = in.readBoolean();
            return new LightFilePath(path, isDirectory);
        }
    }

    private static class LightFilePath {
        @NotNull
        private final String myPath;
        private final boolean myIsDirectory;

        private LightFilePath(@NotNull String path, boolean directory) {
            this.myPath = path;
            this.myIsDirectory = directory;
        }

        private LightFilePath(@NotNull FilePath filePath) {
            this(filePath.getPath(), filePath.isDirectory());
        }

        @NotNull
        public String getPath() {
            return this.myPath;
        }

        public boolean isDirectory() {
            return this.myIsDirectory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LightFilePath path = (LightFilePath)o;
            return this.myIsDirectory == path.myIsDirectory && this.myPath.equals(path.myPath);
        }

        public int hashCode() {
            int result2 = this.myPath.hashCode();
            result2 = 31 * result2 + (this.myIsDirectory ? 1 : 0);
            return result2;
        }
    }

    public static enum ChangeKind {
        MODIFIED(0),
        NOT_CHANGED(1),
        ADDED(2),
        REMOVED(3);

        public final byte id;
        private static final TByteObjectHashMap<ChangeKind> KINDS;

        private ChangeKind(byte id) {
            this.id = id;
        }

        @NotNull
        public static ChangeKind getChangeKindById(byte id) throws IOException {
            ChangeKind kind = (ChangeKind)((Object)KINDS.get(id));
            if (kind == null) {
                throw new IOException("Change kind by id " + id + " not found.");
            }
            return kind;
        }

        static {
            KINDS = new TByteObjectHashMap();
            for (ChangeKind kind : ChangeKind.values()) {
                KINDS.put(kind.id, (Object)kind);
            }
        }
    }

    private static class ChangeKindListKeyDescriptor
    implements DataExternalizer<List<ChangeKind>> {
        private ChangeKindListKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, List<ChangeKind> value) throws IOException {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
            for (ChangeKind data : value) {
                out.writeByte(data.id);
            }
        }

        public List<ChangeKind> read(@NotNull DataInput in) throws IOException {
            List value = ContainerUtil.newSmartList();
            int size = DataInputOutputUtil.readINT((DataInput)in);
            for (int i = 0; i < size; ++i) {
                value.add(ChangeKind.getChangeKindById(in.readByte()));
            }
            return value;
        }
    }

    private static class PathsIndexer
    implements DataIndexer<Integer, List<ChangeKind>, VcsIndexableDetails> {
        @NotNull
        private final VcsLogStorage myStorage;
        @NotNull
        private final PersistentEnumeratorBase<LightFilePath> myPathsEnumerator;
        @NotNull
        private final PersistentHashMap<Couple<Integer>, Collection<Couple<Integer>>> myRenamesMap;
        @NotNull
        private Consumer<? super Exception> myFatalErrorConsumer = arg_0 -> ((Logger)VcsLogPathsIndex.access$900()).error(arg_0);

        private PathsIndexer(@NotNull VcsLogStorage storage2, @NotNull PersistentEnumeratorBase<LightFilePath> enumerator2, @NotNull PersistentHashMap<Couple<Integer>, Collection<Couple<Integer>>> renamesMap) {
            this.myStorage = storage2;
            this.myPathsEnumerator = enumerator2;
            this.myRenamesMap = renamesMap;
        }

        public void setFatalErrorConsumer(@NotNull Consumer<? super Exception> fatalErrorConsumer) {
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }

        @NotNull
        public Map<Integer, List<ChangeKind>> map(@NotNull VcsIndexableDetails inputData) {
            THashMap result2 = new THashMap();
            String rootPath = inputData.getRoot().getPath();
            int parentsCount = inputData.getParents().isEmpty() ? 1 : inputData.getParents().size();
            for (int parentIndex = 0; parentIndex < parentsCount; ++parentIndex) {
                try {
                    THashSet processedParents = new THashSet();
                    SmartList renames = new SmartList();
                    for (Pair pair : inputData.getRenamedPaths(parentIndex)) {
                        int beforeId = this.myPathsEnumerator.enumerate((Object)new LightFilePath((String)pair.first, false));
                        int afterId = this.myPathsEnumerator.enumerate((Object)new LightFilePath((String)pair.second, false));
                        renames.add(Couple.of((Object)beforeId, (Object)afterId));
                        PathsIndexer.getOrCreateChangeKindList((Map<Integer, List<ChangeKind>>)result2, beforeId, parentsCount).set(parentIndex, ChangeKind.REMOVED);
                        PathsIndexer.getOrCreateChangeKindList((Map<Integer, List<ChangeKind>>)result2, afterId, parentsCount).set(parentIndex, ChangeKind.ADDED);
                        this.addParentsToResult((Map<Integer, List<ChangeKind>>)result2, parentIndex, parentsCount, (String)pair.second, rootPath, (Set<? super String>)processedParents);
                        this.addParentsToResult((Map<Integer, List<ChangeKind>>)result2, parentIndex, parentsCount, (String)pair.first, rootPath, (Set<? super String>)processedParents);
                    }
                    if (renames.size() > 0) {
                        int commit2 = this.myStorage.getCommitIndex((Hash)inputData.getId(), inputData.getRoot());
                        int n = this.myStorage.getCommitIndex((Hash)inputData.getParents().get(parentIndex), inputData.getRoot());
                        this.myRenamesMap.put((Object)Couple.of((Object)n, (Object)commit2), (Object)renames);
                    }
                    for (Map.Entry entry : inputData.getModifiedPaths(parentIndex).entrySet()) {
                        this.getOrCreateChangeKindList((Map<Integer, List<ChangeKind>>)result2, new LightFilePath((String)entry.getKey(), false), parentsCount).set(parentIndex, PathsIndexer.createChangeData((Change.Type)entry.getValue()));
                        this.addParentsToResult((Map<Integer, List<ChangeKind>>)result2, parentIndex, parentsCount, (String)entry.getKey(), rootPath, (Set<? super String>)processedParents);
                    }
                    continue;
                }
                catch (IOException e) {
                    this.myFatalErrorConsumer.consume((Object)e);
                }
            }
            return result2;
        }

        private void addParentsToResult(@NotNull Map<Integer, List<ChangeKind>> result2, int parent, int parentsCount, @NotNull String path, @NotNull String rootPath, @NotNull Set<? super String> processedParents) throws IOException {
            String parentPath = PathUtil.getParentPath((String)path);
            while (!processedParents.contains(parentPath) && !FileUtil.PATH_HASHING_STRATEGY.equals((Object)rootPath, (Object)parentPath)) {
                processedParents.add(parentPath);
                this.getOrCreateChangeKindList(result2, new LightFilePath(parentPath, true), parentsCount).set(parent, ChangeKind.MODIFIED);
                parentPath = PathUtil.getParentPath((String)parentPath);
            }
        }

        @NotNull
        private List<ChangeKind> getOrCreateChangeKindList(@NotNull Map<Integer, List<ChangeKind>> pathIdToChangeDataListsMap, @NotNull LightFilePath path, int parentsCount) throws IOException {
            int pathId = this.myPathsEnumerator.enumerate((Object)path);
            return PathsIndexer.getOrCreateChangeKindList(pathIdToChangeDataListsMap, pathId, parentsCount);
        }

        @NotNull
        private static List<ChangeKind> getOrCreateChangeKindList(@NotNull Map<Integer, List<ChangeKind>> pathIdToChangeDataListsMap, int pathId, int parentsCount) {
            List changeDataList = pathIdToChangeDataListsMap.get(pathId);
            if (changeDataList == null) {
                changeDataList = ContainerUtil.newSmartList();
                for (int i = 0; i < parentsCount; ++i) {
                    changeDataList.add(ChangeKind.NOT_CHANGED);
                }
                pathIdToChangeDataListsMap.put(pathId, changeDataList);
            }
            return changeDataList;
        }

        @NotNull
        private static ChangeKind createChangeData(@NotNull Change.Type type) {
            switch (type) {
                case NEW: {
                    return ChangeKind.ADDED;
                }
                case DELETED: {
                    return ChangeKind.REMOVED;
                }
            }
            return ChangeKind.MODIFIED;
        }

        @NotNull
        public PersistentEnumeratorBase<LightFilePath> getPathsEnumerator() {
            return this.myPathsEnumerator;
        }
    }
}

