/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.KeyCollectionBasedForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IntCollectionDataExternalizer;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.VcsUserKeyDescriptor;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.util.StorageId;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUserIndex
extends VcsLogFullDetailsIndex<Void, VcsFullCommitDetails> {
    private static final Logger LOG = Logger.getInstance(VcsLogUserIndex.class);
    public static final String USERS = "users";
    public static final String USERS_IDS = "users-ids";
    @NotNull
    private final UserIndexer myUserIndexer;

    public VcsLogUserIndex(@NotNull StorageId storageId, @NotNull VcsUserRegistry userRegistry, @NotNull FatalErrorHandler consumer, @NotNull Disposable disposableParent) throws IOException {
        super(storageId, USERS, new UserIndexer(VcsLogUserIndex.createUsersEnumerator(storageId, userRegistry)), VoidDataExternalizer.INSTANCE, consumer, disposableParent);
        this.myUserIndexer = (UserIndexer)this.myIndexer;
        ((UserIndexer)this.myIndexer).setFatalErrorConsumer((Consumer<? super Exception>)((Consumer)e -> consumer.consume(this, (Throwable)e)));
    }

    @Override
    @NotNull
    protected ForwardIndex<Integer, Void> createForwardIndex(@NotNull IndexExtension<Integer, Void, VcsFullCommitDetails> extension) throws IOException {
        return new KeyCollectionBasedForwardIndex<Integer, Void>(extension){

            @NotNull
            public PersistentHashMap<Integer, Collection<Integer>> createMap() throws IOException {
                File storageFile = VcsLogUserIndex.this.myStorageId.getStorageFile(VcsLogUserIndex.this.myName + ".idx");
                return new PersistentHashMap(storageFile, (KeyDescriptor)new IntInlineKeyDescriptor(), (DataExternalizer)new IntCollectionDataExternalizer(), Page.PAGE_SIZE);
            }
        };
    }

    @NotNull
    private static PersistentEnumeratorBase<VcsUser> createUsersEnumerator(@NotNull StorageId storageId, @NotNull VcsUserRegistry userRegistry) throws IOException {
        File storageFile = storageId.getStorageFile(USERS_IDS);
        return new PersistentBTreeEnumerator(storageFile, (KeyDescriptor)new VcsUserKeyDescriptor(userRegistry), Page.PAGE_SIZE, null, storageId.getVersion());
    }

    public TIntHashSet getCommitsForUsers(@NotNull Set<? extends VcsUser> users) throws IOException, StorageException {
        HashSet ids = ContainerUtil.newHashSet();
        for (VcsUser vcsUser : users) {
            ids.add(this.myUserIndexer.getUserId(vcsUser));
        }
        return this.getCommitsWithAnyKey(ids);
    }

    @Nullable
    public VcsUser getAuthorForCommit(int commit2) throws IOException {
        Collection userIds = (Collection)this.getKeysForCommit(commit2);
        if (userIds == null || userIds.isEmpty()) {
            return null;
        }
        LOG.assertTrue(userIds.size() == 1);
        return this.myUserIndexer.getUserById((Integer)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((Collection)userIds)));
    }

    public int getUserId(@NotNull VcsUser user) throws IOException {
        return this.myUserIndexer.getUserId(user);
    }

    @Nullable
    public VcsUser getUserById(int id) throws IOException {
        return this.myUserIndexer.getUserById(id);
    }

    @Override
    public void flush() throws StorageException {
        super.flush();
        this.myUserIndexer.flush();
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.myUserIndexer.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    private static class UserIndexer
    implements DataIndexer<Integer, Void, VcsFullCommitDetails> {
        @NotNull
        private final PersistentEnumeratorBase<VcsUser> myUserEnumerator;
        @NotNull
        private Consumer<? super Exception> myFatalErrorConsumer = arg_0 -> ((Logger)VcsLogUserIndex.access$000()).error(arg_0);

        UserIndexer(@NotNull PersistentEnumeratorBase<VcsUser> userEnumerator) {
            this.myUserEnumerator = userEnumerator;
        }

        @NotNull
        public Map<Integer, Void> map(@NotNull VcsFullCommitDetails inputData) {
            THashMap result2 = new THashMap();
            try {
                result2.put(this.myUserEnumerator.enumerate((Object)inputData.getAuthor()), null);
            }
            catch (IOException e) {
                this.myFatalErrorConsumer.consume((Object)e);
            }
            return result2;
        }

        @Nullable
        public VcsUser getUserById(int id) throws IOException {
            return (VcsUser)this.myUserEnumerator.valueOf(id);
        }

        public int getUserId(@NotNull VcsUser user) throws IOException {
            return this.myUserEnumerator.enumerate((Object)user);
        }

        public void setFatalErrorConsumer(@NotNull Consumer<? super Exception> fatalErrorConsumer) {
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }

        public void flush() {
            this.myUserEnumerator.force();
        }

        public void close() throws IOException {
            this.myUserEnumerator.close();
        }
    }
}

