/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph;

import com.google.common.primitives.Ints;
import com.intellij.util.ArrayUtil;
import com.intellij.vcs.log.graph.AbstractGraphCommit;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.IntGraphCommit;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GraphCommitImpl<CommitId>
extends AbstractGraphCommit<CommitId> {
    @NotNull
    private final CommitId myId;
    @NotNull
    private final Object myParents;

    private GraphCommitImpl(@NotNull CommitId id, @NotNull List<CommitId> parents, long timestamp) {
        super(timestamp);
        this.myId = id;
        if (parents.isEmpty()) {
            this.myParents = ArrayUtil.EMPTY_OBJECT_ARRAY;
        } else if (parents.size() == 1) {
            this.myParents = parents.get(0);
            assert (!(this.myParents instanceof Object[]));
        } else {
            this.myParents = parents.toArray();
        }
    }

    @NotNull
    public CommitId getId() {
        return this.myId;
    }

    public CommitId get(int index) {
        if (this.myParents instanceof Object[]) {
            Object[] array = (Object[])this.myParents;
            if (index < 0 || index >= array.length) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return (CommitId)array[index];
        }
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (CommitId)this.myParents;
    }

    public int size() {
        return this.myParents instanceof Object[] ? ((Object[])this.myParents).length : 1;
    }

    @NotNull
    public static <CommitId> GraphCommit<CommitId> createCommit(@NotNull CommitId id, @NotNull List<CommitId> parents, long timestamp) {
        if (id instanceof Integer) {
            return GraphCommitImpl.createIntCommit((Integer)id, parents, timestamp);
        }
        return new GraphCommitImpl<Integer>((Integer)id, parents, timestamp);
    }

    @NotNull
    public static GraphCommit<Integer> createIntCommit(int id, @NotNull List<Integer> parents, long timestamp) {
        if (parents.size() == 1) {
            return new IntGraphCommit.SingleParent(timestamp, id, parents.get(0));
        }
        return new IntGraphCommit.MultiParent(timestamp, id, Ints.toArray(parents));
    }
}

