/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph;

import com.intellij.vcs.log.graph.AbstractGraphCommit;
import org.jetbrains.annotations.NotNull;

abstract class IntGraphCommit
extends AbstractGraphCommit<Integer> {
    private final int myId;

    private IntGraphCommit(long timestamp, int id) {
        super(timestamp);
        this.myId = id;
    }

    @NotNull
    public Integer getId() {
        return this.myId;
    }

    static class MultiParent
    extends IntGraphCommit {
        private final int[] myParents;

        MultiParent(long timestamp, int id, int[] parents) {
            super(timestamp, id);
            this.myParents = parents;
        }

        public int size() {
            return this.myParents.length;
        }

        public Integer get(int index) {
            return this.myParents[index];
        }
    }

    static class SingleParent
    extends IntGraphCommit {
        private final int myParentId;

        SingleParent(long timestamp, int id, int parentId) {
            super(timestamp, id);
            this.myParentId = parentId;
        }

        public int size() {
            return 1;
        }

        public Integer get(int index) {
            if (index != 0) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return this.myParentId;
        }
    }
}

