/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.collapsing.CollapsedGraph;
import com.intellij.vcs.log.graph.collapsing.FragmentGenerator;
import com.intellij.vcs.log.graph.impl.facade.GraphChanges;
import com.intellij.vcs.log.graph.impl.facade.GraphChangesUtil;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.visible.LinearFragmentGenerator;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CollapsedActionManager {
    private static final ActionCase LINEAR_COLLAPSE_CASE = new ActionCase(){

        @Override
        @Nullable
        public LinearGraphController.LinearGraphAnswer performAction(@NotNull ActionContext context) {
            if (CollapsedActionManager.isForDelegateGraph(context)) {
                return null;
            }
            GraphElement affectedGraphElement = context.getAffectedGraphElement();
            if (affectedGraphElement == null) {
                return null;
            }
            LinearFragmentGenerator compiledLinearFragmentGenerator = context.myCompiledFragmentGenerators.linearFragmentGenerator;
            FragmentGenerator compiledFragmentGenerator = context.myCompiledFragmentGenerators.fragmentGenerator;
            if (context.getActionType() == GraphAction.Type.MOUSE_OVER) {
                LinearFragmentGenerator.GraphFragment fragment = compiledLinearFragmentGenerator.getPartLongFragment(affectedGraphElement);
                if (fragment == null) {
                    return null;
                }
                Set<Integer> middleCompiledNodes = compiledFragmentGenerator.getMiddleNodes(fragment.upNodeIndex, fragment.downNodeIndex, false);
                return LinearGraphUtils.createSelectedAnswer(context.getCompiledGraph(), middleCompiledNodes);
            }
            LinearFragmentGenerator.GraphFragment fragment = compiledLinearFragmentGenerator.getLongFragment(affectedGraphElement);
            if (fragment == null) {
                return null;
            }
            Set<Integer> middleCompiledNodes = compiledFragmentGenerator.getMiddleNodes(fragment.upNodeIndex, fragment.downNodeIndex, true);
            HashSet dottedCompiledEdges = ContainerUtil.newHashSet();
            for (Integer middleNodeIndex : middleCompiledNodes) {
                dottedCompiledEdges.addAll(ContainerUtil.filter(context.getCompiledGraph().getAdjacentEdges(middleNodeIndex, EdgeFilter.NORMAL_ALL), edge -> edge.getType() == GraphEdgeType.DOTTED));
            }
            int upNodeIndex = context.convertToDelegateNodeIndex(fragment.upNodeIndex);
            int downNodeIndex = context.convertToDelegateNodeIndex(fragment.downNodeIndex);
            Set<Integer> middleNodes = context.convertToDelegateNodeIndex(middleCompiledNodes);
            Set dottedEdges = ContainerUtil.map2Set((Collection)dottedCompiledEdges, edge -> context.convertToDelegateEdge((GraphEdge)edge));
            CollapsedGraph.Modification modification = context.myCollapsedGraph.startModification();
            for (GraphEdge edge2 : dottedEdges) {
                modification.removeEdge(edge2);
            }
            for (Integer middleNode : middleNodes) {
                modification.hideNode(middleNode);
            }
            modification.createEdge(new GraphEdge(upNodeIndex, downNodeIndex, null, GraphEdgeType.DOTTED));
            modification.apply();
            return new LinearGraphController.LinearGraphAnswer(GraphChangesUtil.SOME_CHANGES);
        }

        @Override
        @NotNull
        public Set<GraphAction.Type> supportedActionTypes() {
            return ContainerUtil.set((Object[])new GraphAction.Type[]{GraphAction.Type.MOUSE_CLICK, GraphAction.Type.MOUSE_OVER});
        }
    };
    private static final ActionCase EXPAND_ALL = new ActionCase(){

        @Override
        @Nullable
        public LinearGraphController.LinearGraphAnswer performAction(@NotNull ActionContext context) {
            CollapsedGraph.Modification modification = context.myCollapsedGraph.startModification();
            modification.removeAdditionalEdges();
            modification.resetNodesVisibility();
            return new DeferredGraphAnswer(GraphChangesUtil.SOME_CHANGES, modification);
        }

        @Override
        @NotNull
        public Set<GraphAction.Type> supportedActionTypes() {
            return Collections.singleton(GraphAction.Type.BUTTON_EXPAND);
        }
    };
    private static final ActionCase COLLAPSE_ALL = new ActionCase(){

        @Override
        @Nullable
        public LinearGraphController.LinearGraphAnswer performAction(@NotNull ActionContext context) {
            CollapsedGraph.Modification modification = context.myCollapsedGraph.startModification();
            modification.removeAdditionalEdges();
            modification.resetNodesVisibility();
            LinearGraph delegateGraph = context.getDelegatedGraph();
            for (int nodeIndex = 0; nodeIndex < delegateGraph.nodesCount(); ++nodeIndex) {
                LinearFragmentGenerator.GraphFragment fragment;
                if (modification.isNodeHidden(nodeIndex) || (fragment = context.myDelegatedFragmentGenerators.linearFragmentGenerator.getLongDownFragment(nodeIndex)) == null) continue;
                Set<Integer> middleNodes = context.myDelegatedFragmentGenerators.fragmentGenerator.getMiddleNodes(fragment.upNodeIndex, fragment.downNodeIndex, true);
                for (Integer nodeIndexForHide : middleNodes) {
                    modification.hideNode(nodeIndexForHide);
                }
                modification.createEdge(new GraphEdge(fragment.upNodeIndex, fragment.downNodeIndex, null, GraphEdgeType.DOTTED));
            }
            return new DeferredGraphAnswer(GraphChangesUtil.SOME_CHANGES, modification);
        }

        @Override
        @NotNull
        public Set<GraphAction.Type> supportedActionTypes() {
            return Collections.singleton(GraphAction.Type.BUTTON_COLLAPSE);
        }
    };
    private static final ActionCase LINEAR_EXPAND_CASE = new ActionCase(){

        @Override
        @Nullable
        public LinearGraphController.LinearGraphAnswer performAction(@NotNull ActionContext context) {
            if (CollapsedActionManager.isForDelegateGraph(context)) {
                return null;
            }
            GraphEdge dottedEdge = CollapsedActionManager.getDottedEdge(context.getAffectedGraphElement(), context.getCompiledGraph());
            if (dottedEdge != null) {
                int upNodeIndex = context.convertToDelegateNodeIndex(CollapsedActionManager.assertInt(dottedEdge.getUpNodeIndex()));
                int downNodeIndex = context.convertToDelegateNodeIndex(CollapsedActionManager.assertInt(dottedEdge.getDownNodeIndex()));
                if (context.getActionType() == GraphAction.Type.MOUSE_OVER) {
                    return LinearGraphUtils.createSelectedAnswer(context.getDelegatedGraph(), ContainerUtil.set((Object[])new Integer[]{upNodeIndex, downNodeIndex}));
                }
                Set<Integer> middleNodes = context.myDelegatedFragmentGenerators.fragmentGenerator.getMiddleNodes(upNodeIndex, downNodeIndex, true);
                CollapsedGraph.Modification modification = context.myCollapsedGraph.startModification();
                for (Integer middleNode : middleNodes) {
                    modification.showNode(middleNode);
                }
                modification.removeEdge(new GraphEdge(upNodeIndex, downNodeIndex, null, GraphEdgeType.DOTTED));
                modification.apply();
                return new LinearGraphController.LinearGraphAnswer(GraphChangesUtil.SOME_CHANGES);
            }
            return null;
        }

        @Override
        @NotNull
        public Set<GraphAction.Type> supportedActionTypes() {
            return ContainerUtil.set((Object[])new GraphAction.Type[]{GraphAction.Type.MOUSE_CLICK, GraphAction.Type.MOUSE_OVER});
        }
    };
    private static final List<ActionCase> FILTER_ACTION_CASES = ContainerUtil.list((Object[])new ActionCase[]{COLLAPSE_ALL, EXPAND_ALL, LINEAR_EXPAND_CASE, LINEAR_COLLAPSE_CASE});

    @Nullable
    public static LinearGraphController.LinearGraphAnswer performAction(@NotNull CollapsedController graphController, @NotNull LinearGraphController.LinearGraphAction action) {
        ActionContext context = new ActionContext(graphController.getCollapsedGraph(), graphController.getPermanentGraphInfo(), action);
        for (ActionCase actionCase : FILTER_ACTION_CASES) {
            LinearGraphController.LinearGraphAnswer graphAnswer;
            if (!actionCase.supportedActionTypes().contains(context.getActionType()) || (graphAnswer = actionCase.performAction(context)) == null) continue;
            return graphAnswer;
        }
        return null;
    }

    public static void expandNodes(@NotNull CollapsedGraph collapsedGraph, Set<Integer> nodesToShow) {
        FragmentGenerator generator = new FragmentGenerator(LinearGraphUtils.asLiteLinearGraph(collapsedGraph.getDelegatedGraph()), (Condition<? super Integer>)((Condition)nodeIndex -> collapsedGraph.isNodeVisible((int)nodeIndex)));
        CollapsedGraph.Modification modification = collapsedGraph.startModification();
        for (Integer nodeToShow : nodesToShow) {
            FragmentGenerator.GreenFragment fragment;
            if (modification.isNodeShown(nodeToShow) || (fragment = generator.getGreenFragmentForCollapse(nodeToShow, Integer.MAX_VALUE)).getUpRedNode() == null || fragment.getDownRedNode() == null || fragment.getUpRedNode().equals(fragment.getDownRedNode())) continue;
            for (Integer n : fragment.getMiddleGreenNodes()) {
                modification.showNode(n);
            }
            modification.removeEdge(GraphEdge.createNormalEdge(fragment.getUpRedNode(), fragment.getDownRedNode(), GraphEdgeType.DOTTED));
        }
        modification.apply();
    }

    private static boolean isForDelegateGraph(@NotNull ActionContext context) {
        GraphElement affectedGraphElement = context.getAffectedGraphElement();
        if (affectedGraphElement == null) {
            return false;
        }
        GraphEdge dottedEdge = CollapsedActionManager.getDottedEdge(context.getAffectedGraphElement(), context.getCompiledGraph());
        if (dottedEdge != null) {
            int upNodeIndex = context.convertToDelegateNodeIndex(CollapsedActionManager.assertInt(dottedEdge.getUpNodeIndex()));
            int downNodeIndex = context.convertToDelegateNodeIndex(CollapsedActionManager.assertInt(dottedEdge.getDownNodeIndex()));
            if (!context.myCollapsedGraph.isMyCollapsedEdge(upNodeIndex, downNodeIndex)) {
                return true;
            }
        }
        return false;
    }

    private CollapsedActionManager() {
    }

    private static int assertInt(@Nullable Integer value) {
        assert (value != null);
        return value;
    }

    @Nullable
    private static GraphEdge getDottedEdge(@Nullable GraphElement graphElement, @NotNull LinearGraph graph2) {
        if (graphElement == null) {
            return null;
        }
        if (graphElement instanceof GraphEdge && ((GraphEdge)graphElement).getType() == GraphEdgeType.DOTTED) {
            return (GraphEdge)graphElement;
        }
        if (graphElement instanceof GraphNode) {
            GraphNode node = (GraphNode)graphElement;
            for (GraphEdge edge : graph2.getAdjacentEdges(node.getNodeIndex(), EdgeFilter.NORMAL_ALL)) {
                if (edge.getType() != GraphEdgeType.DOTTED) continue;
                return edge;
            }
        }
        return null;
    }

    private static class DeferredGraphAnswer
    extends LinearGraphController.LinearGraphAnswer {
        @NotNull
        private final CollapsedGraph.Modification myModification;

        DeferredGraphAnswer(@Nullable GraphChanges<Integer> graphChanges, @NotNull CollapsedGraph.Modification modification) {
            super(graphChanges);
            this.myModification = modification;
        }

        @Override
        @Nullable
        public Runnable getGraphUpdater() {
            return () -> this.myModification.apply();
        }
    }

    private static class FragmentGenerators {
        @NotNull
        private final FragmentGenerator fragmentGenerator;
        @NotNull
        private final LinearFragmentGenerator linearFragmentGenerator;

        private FragmentGenerators(@NotNull LinearGraph linearGraph, @NotNull PermanentGraphInfo<?> permanentGraphInfo, @NotNull UnsignedBitSet matchedNodeId) {
            this.fragmentGenerator = new FragmentGenerator(LinearGraphUtils.asLiteLinearGraph(linearGraph), (Condition<? super Integer>)((Condition)nodeIndex -> matchedNodeId.get(linearGraph.getNodeId((int)nodeIndex))));
            Set<Integer> branchNodeIndexes = LinearGraphUtils.convertIdsToNodeIndexes(linearGraph, permanentGraphInfo.getBranchNodeIds());
            this.linearFragmentGenerator = new LinearFragmentGenerator(LinearGraphUtils.asLiteLinearGraph(linearGraph), branchNodeIndexes);
        }
    }

    private static class ActionContext {
        @NotNull
        private final CollapsedGraph myCollapsedGraph;
        @NotNull
        private final LinearGraphController.LinearGraphAction myGraphAction;
        @NotNull
        private final FragmentGenerators myDelegatedFragmentGenerators;
        @NotNull
        private final FragmentGenerators myCompiledFragmentGenerators;

        private ActionContext(@NotNull CollapsedGraph collapsedGraph, @NotNull PermanentGraphInfo permanentGraphInfo, @NotNull LinearGraphController.LinearGraphAction graphAction) {
            this.myCollapsedGraph = collapsedGraph;
            this.myGraphAction = graphAction;
            this.myDelegatedFragmentGenerators = new FragmentGenerators(collapsedGraph.getDelegatedGraph(), permanentGraphInfo, collapsedGraph.getMatchedNodeId());
            this.myCompiledFragmentGenerators = new FragmentGenerators(collapsedGraph.getCompiledGraph(), permanentGraphInfo, collapsedGraph.getMatchedNodeId());
        }

        @NotNull
        GraphAction.Type getActionType() {
            return this.myGraphAction.getType();
        }

        @Nullable
        GraphElement getAffectedGraphElement() {
            return this.myGraphAction.getAffectedElement() == null ? null : this.myGraphAction.getAffectedElement().getGraphElement();
        }

        @NotNull
        LinearGraph getDelegatedGraph() {
            return this.myCollapsedGraph.getDelegatedGraph();
        }

        @NotNull
        LinearGraph getCompiledGraph() {
            return this.myCollapsedGraph.getCompiledGraph();
        }

        int convertToDelegateNodeIndex(int compiledNodeIndex) {
            return this.myCollapsedGraph.convertToDelegateNodeIndex(compiledNodeIndex);
        }

        @NotNull
        Set<Integer> convertToDelegateNodeIndex(@NotNull Collection<Integer> compiledNodeIndexes) {
            return ContainerUtil.map2Set(compiledNodeIndexes, nodeIndex -> this.convertToDelegateNodeIndex((int)nodeIndex));
        }

        @NotNull
        GraphEdge convertToDelegateEdge(@NotNull GraphEdge compiledEdge) {
            Integer upNodeIndex = null;
            Integer downNodeIndex = null;
            if (compiledEdge.getUpNodeIndex() != null) {
                upNodeIndex = this.convertToDelegateNodeIndex(compiledEdge.getUpNodeIndex());
            }
            if (compiledEdge.getDownNodeIndex() != null) {
                downNodeIndex = this.convertToDelegateNodeIndex(compiledEdge.getDownNodeIndex());
            }
            return new GraphEdge(upNodeIndex, downNodeIndex, compiledEdge.getTargetId(), compiledEdge.getType());
        }
    }

    private static interface ActionCase {
        @Nullable
        public LinearGraphController.LinearGraphAnswer performAction(@NotNull ActionContext var1);

        @NotNull
        public Set<GraphAction.Type> supportedActionTypes();
    }
}

