/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.collapsing;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.collapsing.TreeSetNodeIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FragmentGenerator {
    @NotNull
    private final LiteLinearGraph myGraph;
    @NotNull
    private final Condition<? super Integer> myRedNodes;

    public FragmentGenerator(@NotNull LiteLinearGraph graph2, @NotNull Condition<? super Integer> redNodes) {
        this.myGraph = graph2;
        this.myRedNodes = redNodes;
    }

    @NotNull
    public Set<Integer> getMiddleNodes(int upNode, int downNode, boolean strict) {
        Set<Integer> downWalk = this.getWalkNodes(upNode, false, (Condition<Integer>)((Condition)integer -> integer > downNode));
        Set<Integer> upWalk = this.getWalkNodes(downNode, true, (Condition<Integer>)((Condition)integer -> integer < upNode));
        downWalk.retainAll(upWalk);
        if (strict) {
            downWalk.remove(upNode);
            downWalk.remove(downNode);
        }
        return downWalk;
    }

    @Nullable
    public Integer getNearRedNode(int startNode, int maxWalkSize, boolean isUp) {
        if (this.myRedNodes.value((Object)startNode)) {
            return startNode;
        }
        TreeSetNodeIterator walker = new TreeSetNodeIterator(startNode, isUp);
        while (walker.notEmpty()) {
            Integer next = walker.pop();
            if (this.myRedNodes.value((Object)next)) {
                return next;
            }
            if (maxWalkSize < 0) {
                return null;
            }
            --maxWalkSize;
            walker.addAll(this.getNodes(next, isUp));
        }
        return null;
    }

    @NotNull
    public GreenFragment getGreenFragmentForCollapse(int startNode, int maxWalkSize) {
        if (this.myRedNodes.value((Object)startNode)) {
            return new GreenFragment(null, null, Collections.emptySet());
        }
        Integer upRedNode = this.getNearRedNode(startNode, maxWalkSize, true);
        Integer downRedNode = this.getNearRedNode(startNode, maxWalkSize, false);
        Set<Integer> upPart = upRedNode != null ? this.getMiddleNodes(upRedNode, startNode, false) : this.getWalkNodes(startNode, true, FragmentGenerator.createStopFunction(maxWalkSize));
        Set<Integer> downPart = downRedNode != null ? this.getMiddleNodes(startNode, downRedNode, false) : this.getWalkNodes(startNode, false, FragmentGenerator.createStopFunction(maxWalkSize));
        Set middleNodes = ContainerUtil.union(upPart, downPart);
        if (upRedNode != null) {
            middleNodes.remove(upRedNode);
        }
        if (downRedNode != null) {
            middleNodes.remove(downRedNode);
        }
        return new GreenFragment(upRedNode, downRedNode, middleNodes);
    }

    @NotNull
    private Set<Integer> getWalkNodes(int startNode, boolean isUp, Condition<Integer> stopFunction) {
        HashSet<Integer> walkNodes = new HashSet<Integer>();
        TreeSetNodeIterator walker = new TreeSetNodeIterator(startNode, isUp);
        while (walker.notEmpty()) {
            Integer next = walker.pop();
            if (stopFunction.value((Object)next)) continue;
            walkNodes.add(next);
            walker.addAll(this.getNodes(next, isUp));
        }
        return walkNodes;
    }

    @NotNull
    private List<Integer> getNodes(int nodeIndex, boolean isUp) {
        return this.myGraph.getNodes(nodeIndex, LiteLinearGraph.NodeFilter.filter(isUp));
    }

    @NotNull
    private static Condition<Integer> createStopFunction(final int maxNodeCount) {
        return new Condition<Integer>(){
            private int count;
            {
                this.count = maxNodeCount;
            }

            public boolean value(Integer integer) {
                --this.count;
                return this.count < 0;
            }
        };
    }

    public static class GreenFragment {
        @Nullable
        private final Integer myUpRedNode;
        @Nullable
        private final Integer myDownRedNode;
        @NotNull
        private final Set<Integer> myMiddleGreenNodes;

        private GreenFragment(@Nullable Integer upRedNode, @Nullable Integer downRedNode, @NotNull Set<Integer> middleGreenNodes) {
            this.myUpRedNode = upRedNode;
            this.myDownRedNode = downRedNode;
            this.myMiddleGreenNodes = middleGreenNodes;
        }

        @Nullable
        public Integer getUpRedNode() {
            return this.myUpRedNode;
        }

        @Nullable
        public Integer getDownRedNode() {
            return this.myDownRedNode;
        }

        @NotNull
        public Set<Integer> getMiddleGreenNodes() {
            return this.myMiddleGreenNodes;
        }
    }
}

