/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.collapsing.BranchFilterController;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.impl.facade.BaseController;
import com.intellij.vcs.log.graph.impl.facade.BekBaseController;
import com.intellij.vcs.log.graph.impl.facade.FilteredController;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.ReachableNodes;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import com.intellij.vcs.log.graph.impl.facade.bek.BekSorter;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutBuilder;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphBuilder;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import com.intellij.vcs.log.graph.linearBek.LinearBekController;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import gnu.trove.TIntHashSet;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermanentGraphImpl<CommitId>
implements PermanentGraph<CommitId>,
PermanentGraphInfo<CommitId> {
    @NotNull
    private final PermanentCommitsInfoImpl<CommitId> myPermanentCommitsInfo;
    @NotNull
    private final PermanentLinearGraphImpl myPermanentLinearGraph;
    @NotNull
    private final GraphLayoutImpl myPermanentGraphLayout;
    @NotNull
    private final Set<Integer> myBranchNodeIds;
    @NotNull
    private final Supplier<BekIntMap> myBekIntMap;
    @NotNull
    private final GraphColorManager<CommitId> myGraphColorManager;
    @NotNull
    private final ReachableNodes myReachableNodes;

    public PermanentGraphImpl(@NotNull PermanentLinearGraphImpl permanentLinearGraph, @NotNull GraphLayoutImpl permanentGraphLayout, @NotNull PermanentCommitsInfoImpl<CommitId> permanentCommitsInfo, @NotNull GraphColorManager<CommitId> graphColorManager, @NotNull Set<? extends CommitId> branchesCommitId) {
        this.myPermanentGraphLayout = permanentGraphLayout;
        this.myPermanentCommitsInfo = permanentCommitsInfo;
        this.myPermanentLinearGraph = permanentLinearGraph;
        this.myGraphColorManager = graphColorManager;
        this.myBranchNodeIds = permanentCommitsInfo.convertToNodeIds(branchesCommitId);
        this.myReachableNodes = new ReachableNodes(LinearGraphUtils.asLiteLinearGraph(permanentLinearGraph));
        this.myBekIntMap = Suppliers.memoize(() -> BekSorter.createBekMap(this.myPermanentLinearGraph, this.myPermanentGraphLayout, this.myPermanentCommitsInfo.getTimestampGetter()));
    }

    @NotNull
    public static <CommitId> PermanentGraphImpl<CommitId> newInstance(@NotNull List<? extends GraphCommit<CommitId>> graphCommits, @NotNull GraphColorManager<CommitId> graphColorManager, @NotNull Set<? extends CommitId> branchesCommitId) {
        PermanentLinearGraphBuilder permanentLinearGraphBuilder = PermanentLinearGraphBuilder.newInstance(graphCommits);
        NotLoadedCommitsIdsGenerator idsGenerator = new NotLoadedCommitsIdsGenerator();
        PermanentLinearGraphImpl linearGraph = permanentLinearGraphBuilder.build(idsGenerator);
        PermanentCommitsInfoImpl commitIdPermanentCommitsInfo = PermanentCommitsInfoImpl.newInstance(graphCommits, idsGenerator.getNotLoadedCommits());
        GraphLayoutImpl permanentGraphLayout = GraphLayoutBuilder.build(linearGraph, (nodeIndex1, nodeIndex2) -> {
            Object commitId1 = commitIdPermanentCommitsInfo.getCommitId((int)nodeIndex1);
            Object commitId2 = commitIdPermanentCommitsInfo.getCommitId((int)nodeIndex2);
            return graphColorManager.compareHeads(commitId1, commitId2);
        });
        return new PermanentGraphImpl<CommitId>(linearGraph, permanentGraphLayout, commitIdPermanentCommitsInfo, graphColorManager, branchesCommitId);
    }

    @NotNull
    private LinearGraphController createBaseController(@NotNull PermanentGraph.SortType sortType) {
        if (sortType == PermanentGraph.SortType.Normal) {
            return new BaseController(this);
        }
        if (sortType == PermanentGraph.SortType.LinearBek) {
            return new LinearBekController(new BekBaseController(this, (BekIntMap)this.myBekIntMap.get()), (PermanentGraphInfo)this);
        }
        return new BekBaseController(this, (BekIntMap)this.myBekIntMap.get());
    }

    @NotNull
    private LinearGraphController createFilteredController(@NotNull LinearGraphController baseController, @NotNull PermanentGraph.SortType sortType, @Nullable Set<? extends CommitId> visibleHeads, @Nullable Set<? extends CommitId> matchingCommits) {
        Set<Integer> visibleHeadsIds;
        Set<Integer> set2 = visibleHeadsIds = visibleHeads != null ? this.myPermanentCommitsInfo.convertToNodeIds(visibleHeads, true) : null;
        if (matchingCommits != null) {
            return new FilteredController(baseController, this, this.myPermanentCommitsInfo.convertToNodeIds(matchingCommits), visibleHeadsIds);
        }
        if (sortType == PermanentGraph.SortType.LinearBek) {
            if (visibleHeadsIds != null) {
                return new BranchFilterController(baseController, this, visibleHeadsIds);
            }
            return baseController;
        }
        return new CollapsedController(baseController, this, visibleHeadsIds);
    }

    @NotNull
    public VisibleGraph<CommitId> createVisibleGraph(@NotNull PermanentGraph.SortType sortType, @Nullable Set<? extends CommitId> visibleHeads, @Nullable Set<? extends CommitId> matchingCommits, @NotNull BiConsumer<? super LinearGraphController, ? super PermanentGraphInfo<CommitId>> preprocessor) {
        LinearGraphController controller = this.createFilteredController(this.createBaseController(sortType), sortType, visibleHeads, matchingCommits);
        preprocessor.accept(controller, this);
        return new VisibleGraphImpl<CommitId>(controller, this, this.myGraphColorManager);
    }

    @NotNull
    public VisibleGraph<CommitId> createVisibleGraph(@NotNull PermanentGraph.SortType sortType, @Nullable Set<? extends CommitId> visibleHeads, @Nullable Set<? extends CommitId> matchingCommits) {
        return this.createVisibleGraph(sortType, visibleHeads, matchingCommits, (controller, info) -> {});
    }

    @NotNull
    public List<GraphCommit<CommitId>> getAllCommits() {
        return new AbstractList<GraphCommit<CommitId>>(){

            @Override
            public GraphCommit<CommitId> get(int index) {
                Object commitId = PermanentGraphImpl.this.myPermanentCommitsInfo.getCommitId(index);
                List<Integer> downNodes = LinearGraphUtils.getDownNodesIncludeNotLoad(PermanentGraphImpl.this.myPermanentLinearGraph, index);
                List parentsCommitIds = PermanentGraphImpl.this.myPermanentCommitsInfo.convertToCommitIdList(downNodes);
                return GraphCommitImpl.createCommit(commitId, parentsCommitIds, PermanentGraphImpl.this.myPermanentCommitsInfo.getTimestamp(index));
            }

            @Override
            public int size() {
                return PermanentGraphImpl.this.myPermanentLinearGraph.nodesCount();
            }
        };
    }

    @NotNull
    public List<CommitId> getChildren(@NotNull CommitId commit2) {
        int commitIndex = this.myPermanentCommitsInfo.getNodeId(commit2);
        return this.myPermanentCommitsInfo.convertToCommitIdList(LinearGraphUtils.getUpNodes(this.myPermanentLinearGraph, commitIndex));
    }

    @NotNull
    public Set<CommitId> getContainingBranches(@NotNull CommitId commit2) {
        int commitIndex = this.myPermanentCommitsInfo.getNodeId(commit2);
        return this.myPermanentCommitsInfo.convertToCommitIdSet(this.myReachableNodes.getContainingBranches(commitIndex, this.myBranchNodeIds));
    }

    @NotNull
    public Condition<CommitId> getContainedInBranchCondition(@NotNull Collection<? extends CommitId> heads) {
        List headIds = ContainerUtil.map(heads, head -> this.myPermanentCommitsInfo.getNodeId(head));
        if (!heads.isEmpty() && ContainerUtil.getFirstItem(heads) instanceof Integer) {
            TIntHashSet branchNodes = new TIntHashSet();
            this.myReachableNodes.walkDown(headIds, (Consumer<Integer>)((Consumer)node -> branchNodes.add(((Integer)this.myPermanentCommitsInfo.getCommitId((int)node)).intValue())));
            return new IntContainedInBranchCondition(branchNodes);
        }
        HashSet branchNodes = ContainerUtil.newHashSet();
        this.myReachableNodes.walkDown(headIds, (Consumer<Integer>)((Consumer)node -> branchNodes.add(this.myPermanentCommitsInfo.getCommitId((int)node))));
        return new ContainedInBranchCondition(branchNodes);
    }

    @Override
    @NotNull
    public PermanentCommitsInfoImpl<CommitId> getPermanentCommitsInfo() {
        return this.myPermanentCommitsInfo;
    }

    @Override
    @NotNull
    public PermanentLinearGraphImpl getLinearGraph() {
        return this.myPermanentLinearGraph;
    }

    @Override
    @NotNull
    public GraphLayoutImpl getPermanentGraphLayout() {
        return this.myPermanentGraphLayout;
    }

    @Override
    @NotNull
    public Set<Integer> getBranchNodeIds() {
        return this.myBranchNodeIds;
    }

    private static class ContainedInBranchCondition<CommitId>
    implements Condition<CommitId> {
        private final Set<CommitId> myBranchNodes;

        ContainedInBranchCondition(Set<CommitId> branchNodes) {
            this.myBranchNodes = branchNodes;
        }

        public boolean value(CommitId commitId) {
            return this.myBranchNodes.contains(commitId);
        }
    }

    private static class IntContainedInBranchCondition<CommitId>
    implements Condition<CommitId> {
        private final TIntHashSet myBranchNodes;

        IntContainedInBranchCondition(TIntHashSet branchNodes) {
            this.myBranchNodes = branchNodes;
        }

        public boolean value(CommitId commitId) {
            return this.myBranchNodes.contains(((Integer)commitId).intValue());
        }
    }

    private static class NotLoadedCommitsIdsGenerator<CommitId>
    implements NotNullFunction<CommitId, Integer> {
        @NotNull
        private final Map<Integer, CommitId> myNotLoadedCommits = ContainerUtil.newHashMap();

        private NotLoadedCommitsIdsGenerator() {
        }

        @NotNull
        public Integer fun(CommitId dom) {
            int nodeId = -(this.myNotLoadedCommits.size() + 2);
            this.myNotLoadedCommits.put(nodeId, dom);
            return nodeId;
        }

        @NotNull
        public Map<Integer, CommitId> getNotLoadedCommits() {
            return this.myNotLoadedCommits;
        }
    }
}

