/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphBuilder;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import com.intellij.vcs.log.graph.utils.impl.IntTimestampGetter;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SimpleGraphInfo<CommitId>
implements PermanentGraphInfo<CommitId> {
    @NotNull
    private final LinearGraph myLinearGraph;
    @NotNull
    private final GraphLayout myGraphLayout;
    @NotNull
    private final NotNullFunction<? super Integer, ? extends CommitId> myFunction;
    @NotNull
    private final TimestampGetter myTimestampGetter;
    @NotNull
    private final Set<Integer> myBranchNodeIds;

    private SimpleGraphInfo(@NotNull LinearGraph linearGraph, @NotNull GraphLayout graphLayout, @NotNull NotNullFunction<? super Integer, ? extends CommitId> function, @NotNull TimestampGetter timestampGetter, @NotNull Set<Integer> branchNodeIds) {
        this.myLinearGraph = linearGraph;
        this.myGraphLayout = graphLayout;
        this.myFunction = function;
        this.myTimestampGetter = timestampGetter;
        this.myBranchNodeIds = branchNodeIds;
    }

    public static <CommitId> SimpleGraphInfo<CommitId> build(@NotNull LinearGraph linearGraph, @NotNull GraphLayout oldLayout, @NotNull PermanentCommitsInfo<CommitId> permanentCommitsInfo, int permanentGraphSize, @NotNull Set<Integer> branchNodeIds, int visibleRow, int visibleRange) {
        int start2 = Math.max(0, visibleRow - visibleRange);
        int end = Math.min(linearGraph.nodesCount(), start2 + 2 * visibleRange);
        ArrayList graphCommits = ContainerUtil.newArrayListWithCapacity((int)(end - start2));
        ArrayList commitsIdMap = ContainerUtil.newArrayListWithCapacity((int)(end - start2));
        for (int row2 = start2; row2 < end; ++row2) {
            int nodeId = linearGraph.getNodeId(row2);
            CommitId commit2 = permanentCommitsInfo.getCommitId(nodeId);
            List parents = ContainerUtil.newSmartList();
            parents.addAll(ContainerUtil.mapNotNull(LinearGraphUtils.asLiteLinearGraph(linearGraph).getNodes(row2, LiteLinearGraph.NodeFilter.DOWN), row1 -> {
                if (row1 < start2 || row1 >= end) {
                    return null;
                }
                return permanentCommitsInfo.getCommitId(linearGraph.getNodeId((int)row1));
            }));
            graphCommits.add(GraphCommitImpl.createCommit(commit2, parents, permanentCommitsInfo.getTimestamp(nodeId)));
            commitsIdMap.add(commit2);
        }
        IntTimestampGetter timestampGetter = PermanentCommitsInfoImpl.createTimestampGetter(graphCommits);
        NotNullFunction<Integer, CommitId> commitIdMapping = SimpleGraphInfo.createCommitIdMapFunction(commitsIdMap);
        PermanentLinearGraphImpl newLinearGraph = PermanentLinearGraphBuilder.newInstance(graphCommits).build();
        int[] layoutIndexes = new int[end - start2];
        ArrayList headNodeIndexes = ContainerUtil.newArrayList();
        TObjectIntHashMap<CommitId> commitIdToInteger = SimpleGraphInfo.reverseCommitIdMap(permanentCommitsInfo, permanentGraphSize);
        for (int row3 = start2; row3 < end; ++row3) {
            int layoutIndex;
            Object commitId = commitsIdMap.get(row3 - start2);
            layoutIndexes[row3 - start2] = layoutIndex = oldLayout.getLayoutIndex(commitIdToInteger.get(commitId));
            if (!LinearGraphUtils.asLiteLinearGraph(newLinearGraph).getNodes(row3 - start2, LiteLinearGraph.NodeFilter.UP).isEmpty()) continue;
            headNodeIndexes.add(row3 - start2);
        }
        ContainerUtil.sort((List)headNodeIndexes, Comparator.comparingInt(o -> layoutIndexes[o]));
        int[] starts = new int[headNodeIndexes.size()];
        for (int i = 0; i < starts.length; ++i) {
            starts[i] = layoutIndexes[(Integer)headNodeIndexes.get(i)];
        }
        GraphLayoutImpl newLayout = new GraphLayoutImpl(layoutIndexes, headNodeIndexes, starts);
        return new SimpleGraphInfo<CommitId>(newLinearGraph, newLayout, commitIdMapping, timestampGetter, LinearGraphUtils.convertIdsToNodeIndexes(linearGraph, branchNodeIds));
    }

    @NotNull
    private static <CommitId> NotNullFunction<Integer, CommitId> createCommitIdMapFunction(@NotNull List<? extends CommitId> commitsIdMap) {
        if (!commitsIdMap.isEmpty() && commitsIdMap.get(0) instanceof Integer) {
            int[] ints = new int[commitsIdMap.size()];
            for (int row2 = 0; row2 < commitsIdMap.size(); ++row2) {
                ints[row2] = (Integer)commitsIdMap.get(row2);
            }
            return new IntegerCommitIdMapFunction(CompressedIntList.newInstance(ints));
        }
        return new CommitIdMapFunction<CommitId>(commitsIdMap);
    }

    @NotNull
    private static <CommitId> TObjectIntHashMap<CommitId> reverseCommitIdMap(@NotNull PermanentCommitsInfo<CommitId> permanentCommitsInfo, int size) {
        TObjectIntHashMap result2 = new TObjectIntHashMap();
        for (int i = 0; i < size; ++i) {
            result2.put(permanentCommitsInfo.getCommitId(i), i);
        }
        return result2;
    }

    @Override
    @NotNull
    public PermanentCommitsInfo<CommitId> getPermanentCommitsInfo() {
        return new PermanentCommitsInfo<CommitId>(){

            @Override
            @NotNull
            public CommitId getCommitId(int nodeId) {
                return SimpleGraphInfo.this.myFunction.fun((Object)nodeId);
            }

            @Override
            public long getTimestamp(int nodeId) {
                return SimpleGraphInfo.this.myTimestampGetter.getTimestamp(nodeId);
            }

            @Override
            public int getNodeId(@NotNull CommitId commitId) {
                for (int id = 0; id < SimpleGraphInfo.this.myLinearGraph.nodesCount(); ++id) {
                    if (!SimpleGraphInfo.this.myFunction.fun((Object)id).equals(commitId)) continue;
                    return id;
                }
                return -1;
            }

            @Override
            @NotNull
            public Set<Integer> convertToNodeIds(@NotNull Collection<? extends CommitId> heads) {
                HashSet result2 = ContainerUtil.newHashSet();
                for (int id = 0; id < SimpleGraphInfo.this.myLinearGraph.nodesCount(); ++id) {
                    if (!heads.contains(SimpleGraphInfo.this.myFunction.fun((Object)id))) continue;
                    result2.add(id);
                }
                return result2;
            }
        };
    }

    @Override
    @NotNull
    public LinearGraph getLinearGraph() {
        return this.myLinearGraph;
    }

    @Override
    @NotNull
    public GraphLayout getPermanentGraphLayout() {
        return this.myGraphLayout;
    }

    @Override
    @NotNull
    public Set<Integer> getBranchNodeIds() {
        return this.myBranchNodeIds;
    }

    private static class IntegerCommitIdMapFunction
    implements NotNullFunction<Integer, Integer> {
        private final IntList myCommitsIdMap;

        IntegerCommitIdMapFunction(IntList commitsIdMap) {
            this.myCommitsIdMap = commitsIdMap;
        }

        @NotNull
        public Integer fun(Integer dom) {
            return this.myCommitsIdMap.get(dom);
        }
    }

    private static class CommitIdMapFunction<CommitId>
    implements NotNullFunction<Integer, CommitId> {
        private final List<? extends CommitId> myCommitsIdMap;

        CommitIdMapFunction(List<? extends CommitId> commitsIdMap) {
            this.myCommitsIdMap = commitsIdMap;
        }

        @NotNull
        public CommitId fun(Integer dom) {
            return this.myCommitsIdMap.get(dom);
        }
    }
}

