/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GraphLayoutImpl
implements GraphLayout {
    @NotNull
    private final IntList myLayoutIndex;
    @NotNull
    private final List<Integer> myHeadNodeIndex;
    @NotNull
    private final int[] myStartLayoutIndexForHead;

    public GraphLayoutImpl(@NotNull int[] layoutIndex, @NotNull List<Integer> headNodeIndex, @NotNull int[] startLayoutIndexForHead) {
        this.myLayoutIndex = CompressedIntList.newInstance(layoutIndex);
        this.myHeadNodeIndex = headNodeIndex;
        this.myStartLayoutIndexForHead = startLayoutIndexForHead;
    }

    @Override
    public int getLayoutIndex(int nodeIndex) {
        return this.myLayoutIndex.get(nodeIndex);
    }

    @Override
    public int getOneOfHeadNodeIndex(int nodeIndex) {
        return this.getHeadNodeIndex(this.getLayoutIndex(nodeIndex));
    }

    public int getHeadNodeIndex(int layoutIndex) {
        return this.myHeadNodeIndex.get(this.getHeadOrder(layoutIndex));
    }

    @Override
    @NotNull
    public List<Integer> getHeadNodeIndex() {
        return this.myHeadNodeIndex;
    }

    private int getHeadOrder(int layoutIndex) {
        int i = Arrays.binarySearch(this.myStartLayoutIndexForHead, layoutIndex);
        return i < 0 ? Math.max(0, -i - 2) : i;
    }
}

