/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.linearBek;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.BekBaseController;
import com.intellij.vcs.log.graph.impl.facade.CascadeController;
import com.intellij.vcs.log.graph.impl.facade.GraphChangesUtil;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import com.intellij.vcs.log.graph.linearBek.LinearBekGraph;
import com.intellij.vcs.log.graph.linearBek.LinearBekGraphBuilder;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearBekController
extends CascadeController {
    private static final Logger LOG = Logger.getInstance(LinearBekController.class);
    @NotNull
    private final LinearBekGraph myCompiledGraph = new LinearBekGraph(this.getDelegateGraph());
    private final LinearBekGraphBuilder myLinearBekGraphBuilder;
    private final BekGraphLayout myBekGraphLayout;

    public LinearBekController(@NotNull BekBaseController controller, @NotNull PermanentGraphInfo permanentGraphInfo) {
        super(controller, permanentGraphInfo);
        this.myBekGraphLayout = new BekGraphLayout(permanentGraphInfo.getPermanentGraphLayout(), controller.getBekIntMap());
        this.myLinearBekGraphBuilder = new LinearBekGraphBuilder(this.myCompiledGraph, this.myBekGraphLayout);
        long start2 = System.currentTimeMillis();
        this.myLinearBekGraphBuilder.collapseAll();
        LOG.debug("Linear bek took " + (double)(System.currentTimeMillis() - start2) / 1000.0 + " sec");
    }

    @Override
    @NotNull
    protected LinearGraphController.LinearGraphAnswer delegateGraphChanged(@NotNull LinearGraphController.LinearGraphAnswer delegateAnswer) {
        return delegateAnswer;
    }

    @Override
    @Nullable
    protected LinearGraphController.LinearGraphAnswer performAction(@NotNull LinearGraphController.LinearGraphAction action) {
        if (action.getAffectedElement() != null) {
            if (action.getType() == GraphAction.Type.MOUSE_CLICK) {
                GraphElement graphElement = action.getAffectedElement().getGraphElement();
                if (graphElement instanceof GraphNode) {
                    LinearGraphController.LinearGraphAnswer answer = this.collapseNode((GraphNode)graphElement);
                    if (answer != null) {
                        return answer;
                    }
                    for (GraphEdge dottedEdge : this.getAllAdjacentDottedEdges((GraphNode)graphElement)) {
                        LinearGraphController.LinearGraphAnswer expandedAnswer = this.expandEdge(dottedEdge);
                        if (expandedAnswer == null) continue;
                        return expandedAnswer;
                    }
                } else if (graphElement instanceof GraphEdge) {
                    return this.expandEdge((GraphEdge)graphElement);
                }
            } else if (action.getType() == GraphAction.Type.MOUSE_OVER) {
                GraphElement graphElement = action.getAffectedElement().getGraphElement();
                if (graphElement instanceof GraphNode) {
                    LinearGraphController.LinearGraphAnswer answer = this.highlightNode((GraphNode)graphElement);
                    if (answer != null) {
                        return answer;
                    }
                    for (GraphEdge dottedEdge : this.getAllAdjacentDottedEdges((GraphNode)graphElement)) {
                        LinearGraphController.LinearGraphAnswer highlightAnswer = this.highlightEdge(dottedEdge);
                        if (highlightAnswer == null) continue;
                        return highlightAnswer;
                    }
                } else if (graphElement instanceof GraphEdge) {
                    return this.highlightEdge((GraphEdge)graphElement);
                }
            }
        } else {
            if (action.getType() == GraphAction.Type.BUTTON_COLLAPSE) {
                return this.collapseAll();
            }
            if (action.getType() == GraphAction.Type.BUTTON_EXPAND) {
                return this.expandAll();
            }
        }
        return null;
    }

    @NotNull
    private List<GraphEdge> getAllAdjacentDottedEdges(GraphNode graphElement) {
        return ContainerUtil.filter(this.myCompiledGraph.getAdjacentEdges(graphElement.getNodeIndex(), EdgeFilter.ALL), graphEdge -> graphEdge.getType() == GraphEdgeType.DOTTED);
    }

    @NotNull
    private LinearGraphController.LinearGraphAnswer expandAll() {
        return new LinearGraphController.LinearGraphAnswer(GraphChangesUtil.SOME_CHANGES){

            @Override
            @Nullable
            public Runnable getGraphUpdater() {
                return () -> {
                    ((LinearBekController)LinearBekController.this).myCompiledGraph.myDottedEdges.removeAll();
                    ((LinearBekController)LinearBekController.this).myCompiledGraph.myHiddenEdges.removeAll();
                };
            }
        };
    }

    @NotNull
    private LinearGraphController.LinearGraphAnswer collapseAll() {
        final LinearBekGraph.WorkingLinearBekGraph workingGraph = new LinearBekGraph.WorkingLinearBekGraph(this.myCompiledGraph);
        new LinearBekGraphBuilder(workingGraph, this.myBekGraphLayout).collapseAll();
        return new LinearGraphController.LinearGraphAnswer(GraphChangesUtil.edgesReplaced(workingGraph.getRemovedEdges(), workingGraph.getAddedEdges(), this.getDelegateGraph())){

            @Override
            @Nullable
            public Runnable getGraphUpdater() {
                return () -> workingGraph.applyChanges();
            }
        };
    }

    @Nullable
    private LinearGraphController.LinearGraphAnswer highlightNode(GraphNode node) {
        Set<LinearBekGraphBuilder.MergeFragment> toCollapse = this.collectFragmentsToCollapse(node);
        if (toCollapse.isEmpty()) {
            return null;
        }
        HashSet toHighlight = ContainerUtil.newHashSet();
        for (LinearBekGraphBuilder.MergeFragment fragment : toCollapse) {
            toHighlight.addAll(fragment.getAllNodes());
        }
        return LinearGraphUtils.createSelectedAnswer(this.myCompiledGraph, toHighlight);
    }

    @Nullable
    private LinearGraphController.LinearGraphAnswer highlightEdge(GraphEdge edge) {
        if (edge.getType() == GraphEdgeType.DOTTED) {
            return LinearGraphUtils.createSelectedAnswer(this.myCompiledGraph, ContainerUtil.set((Object[])new Integer[]{edge.getUpNodeIndex(), edge.getDownNodeIndex()}));
        }
        return null;
    }

    @Nullable
    private LinearGraphController.LinearGraphAnswer collapseNode(GraphNode node) {
        SortedSet<Integer> toCollapse = this.collectNodesToCollapse(node);
        if (toCollapse.isEmpty()) {
            return null;
        }
        for (Integer i : toCollapse) {
            this.myLinearBekGraphBuilder.collapseFragment(i);
        }
        return new LinearGraphController.LinearGraphAnswer(GraphChangesUtil.SOME_CHANGES);
    }

    private SortedSet<Integer> collectNodesToCollapse(GraphNode node) {
        TreeSet<Integer> toCollapse = new TreeSet<Integer>(Comparator.reverseOrder());
        for (LinearBekGraphBuilder.MergeFragment f : this.collectFragmentsToCollapse(node)) {
            toCollapse.add(f.getParent());
            toCollapse.addAll(f.getTailsAndBody());
        }
        return toCollapse;
    }

    @NotNull
    private Set<LinearBekGraphBuilder.MergeFragment> collectFragmentsToCollapse(GraphNode node) {
        HashSet result2 = ContainerUtil.newHashSet();
        int mergesCount = 0;
        LinkedHashSet toProcess = ContainerUtil.newLinkedHashSet();
        toProcess.add(node.getNodeIndex());
        while (!toProcess.isEmpty()) {
            Integer i = (Integer)ContainerUtil.getFirstItem((Collection)toProcess);
            toProcess.remove(i);
            LinearBekGraphBuilder.MergeFragment fragment = this.myLinearBekGraphBuilder.getFragment(i);
            if (fragment == null) continue;
            result2.add(fragment);
            toProcess.addAll(fragment.getTailsAndBody());
            if (++mergesCount <= 10) continue;
            break;
        }
        return result2;
    }

    @Nullable
    private LinearGraphController.LinearGraphAnswer expandEdge(GraphEdge edge) {
        if (edge.getType() == GraphEdgeType.DOTTED) {
            return new LinearGraphController.LinearGraphAnswer(GraphChangesUtil.edgesReplaced(Collections.singleton(edge), this.myCompiledGraph.expandEdge(edge), this.getDelegateGraph()));
        }
        return null;
    }

    @NotNull
    private LinearGraph getDelegateGraph() {
        return this.getDelegateController().getCompiledGraph();
    }

    @Override
    @NotNull
    public LinearGraph getCompiledGraph() {
        return this.myCompiledGraph;
    }

    private static class BekGraphLayout
    implements GraphLayout {
        private final GraphLayout myGraphLayout;
        private final BekIntMap myBekIntMap;

        BekGraphLayout(GraphLayout graphLayout, BekIntMap bekIntMap) {
            this.myGraphLayout = graphLayout;
            this.myBekIntMap = bekIntMap;
        }

        @Override
        public int getLayoutIndex(int nodeIndex) {
            return this.myGraphLayout.getLayoutIndex(this.myBekIntMap.getUsualIndex(nodeIndex));
        }

        @Override
        public int getOneOfHeadNodeIndex(int nodeIndex) {
            int usualIndex = this.myGraphLayout.getOneOfHeadNodeIndex(this.myBekIntMap.getUsualIndex(nodeIndex));
            return this.myBekIntMap.getBekIndex(usualIndex);
        }

        @Override
        @NotNull
        public List<Integer> getHeadNodeIndex() {
            ArrayList<Integer> bekIndexes = new ArrayList<Integer>();
            for (int head : this.myGraphLayout.getHeadNodeIndex()) {
                bekIndexes.add(this.myBekIntMap.getBekIndex(head));
            }
            return bekIndexes;
        }
    }
}

