/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import gnu.trove.TIntObjectHashMap;
import java.util.AbstractList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class IntIntMultiMap {
    private static final int[] EMPTY = new int[0];
    private final TIntObjectHashMap<int[]> myKeyToArrayMap = new TIntObjectHashMap();

    public void putValue(int key, int value) {
        int[] values = (int[])this.myKeyToArrayMap.get(key);
        if (values == null) {
            int[] newValues = new int[]{value};
            this.myKeyToArrayMap.put(key, (Object)newValues);
        } else {
            int[] newValues = new int[values.length + 1];
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == value) {
                    return;
                }
                newValues[i] = values[i];
            }
            newValues[newValues.length - 1] = value;
            this.myKeyToArrayMap.put(key, (Object)newValues);
        }
    }

    public void remove(int key, int value) {
        int removeIndex = -1;
        int[] values = (int[])this.myKeyToArrayMap.get(key);
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != value) continue;
            removeIndex = i;
            break;
        }
        if (removeIndex == -1) {
            return;
        }
        if (values.length == 1) {
            this.myKeyToArrayMap.remove(key);
            return;
        }
        int[] newValues = new int[values.length - 1];
        for (int i = 0; i < newValues.length; ++i) {
            newValues[i] = i >= removeIndex ? values[i + 1] : values[i];
        }
        this.myKeyToArrayMap.put(key, (Object)newValues);
    }

    @NotNull
    public Collection<Integer> get(int key) {
        final int[] asArray = this.getAsArray(key);
        return new AbstractList<Integer>(){

            @Override
            @NotNull
            public Integer get(int index) {
                return asArray[index];
            }

            @Override
            public int size() {
                return asArray.length;
            }
        };
    }

    @NotNull
    public int[] getAsArray(int key) {
        int[] result2 = (int[])this.myKeyToArrayMap.get(key);
        if (result2 == null) {
            return EMPTY;
        }
        return result2;
    }

    public boolean isEmpty() {
        return this.myKeyToArrayMap.isEmpty();
    }

    public boolean containsKey(int key) {
        return this.myKeyToArrayMap.containsKey(key);
    }

    @NotNull
    public int[] keys() {
        return this.myKeyToArrayMap.keys();
    }

    public void clear() {
        this.myKeyToArrayMap.clear();
    }
}

