/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.utils.NormalEdge;
import java.awt.Cursor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearGraphUtils {
    public static final LinearGraphController.LinearGraphAnswer DEFAULT_GRAPH_ANSWER = new LinearGraphController.LinearGraphAnswer(Cursor.getDefaultCursor(), null);

    public static boolean intEqual(@Nullable Integer value, int number) {
        return value != null && value == number;
    }

    public static boolean isEdgeUp(@NotNull GraphEdge edge, int nodeIndex) {
        return LinearGraphUtils.intEqual(edge.getDownNodeIndex(), nodeIndex);
    }

    public static boolean isEdgeDown(@NotNull GraphEdge edge, int nodeIndex) {
        return LinearGraphUtils.intEqual(edge.getUpNodeIndex(), nodeIndex);
    }

    public static boolean isNormalEdge(@Nullable GraphEdge edge) {
        if (edge != null && edge.getType().isNormalEdge()) {
            assert (edge.getUpNodeIndex() != null && edge.getDownNodeIndex() != null);
            return true;
        }
        return false;
    }

    @Nullable
    public static NormalEdge asNormalEdge(@Nullable GraphEdge edge) {
        if (LinearGraphUtils.isNormalEdge(edge)) {
            assert (edge.getUpNodeIndex() != null && edge.getDownNodeIndex() != null);
            return NormalEdge.create(edge.getUpNodeIndex(), edge.getDownNodeIndex());
        }
        return null;
    }

    public static int getNotNullNodeIndex(@NotNull GraphEdge edge) {
        if (edge.getUpNodeIndex() != null) {
            return edge.getUpNodeIndex();
        }
        assert (edge.getDownNodeIndex() != null);
        return edge.getDownNodeIndex();
    }

    @NotNull
    public static List<Integer> getUpNodes(@NotNull LinearGraph graph2, int nodeIndex) {
        return ContainerUtil.mapNotNull(graph2.getAdjacentEdges(nodeIndex, EdgeFilter.NORMAL_UP), graphEdge -> graphEdge.getUpNodeIndex());
    }

    @NotNull
    public static List<Integer> getDownNodes(@NotNull LinearGraph graph2, int nodeIndex) {
        return ContainerUtil.mapNotNull(graph2.getAdjacentEdges(nodeIndex, EdgeFilter.NORMAL_DOWN), graphEdge -> graphEdge.getDownNodeIndex());
    }

    @NotNull
    public static List<Integer> getDownNodesIncludeNotLoad(@NotNull LinearGraph graph2, int nodeIndex) {
        return ContainerUtil.mapNotNull(graph2.getAdjacentEdges(nodeIndex, EdgeFilter.ALL), graphEdge -> {
            if (LinearGraphUtils.isEdgeDown(graphEdge, nodeIndex)) {
                if (graphEdge.getType() == GraphEdgeType.NOT_LOAD_COMMIT) {
                    return graphEdge.getTargetId();
                }
                return graphEdge.getDownNodeIndex();
            }
            return null;
        });
    }

    @NotNull
    public static LiteLinearGraph asLiteLinearGraph(final @NotNull LinearGraph graph2) {
        return new LiteLinearGraph(){

            @Override
            public int nodesCount() {
                return graph2.nodesCount();
            }

            @Override
            @NotNull
            public List<Integer> getNodes(int nodeIndex, @NotNull LiteLinearGraph.NodeFilter filter) {
                return ContainerUtil.mapNotNull(graph2.getAdjacentEdges(nodeIndex, filter.edgeFilter), edge -> {
                    if (LinearGraphUtils.isEdgeUp(edge, nodeIndex)) {
                        return edge.getUpNodeIndex();
                    }
                    if (LinearGraphUtils.isEdgeDown(edge, nodeIndex)) {
                        return edge.getDownNodeIndex();
                    }
                    return null;
                });
            }
        };
    }

    @NotNull
    public static Cursor getCursor(boolean hand) {
        if (hand) {
            return Cursor.getPredefinedCursor(12);
        }
        return Cursor.getDefaultCursor();
    }

    public static LinearGraphController.LinearGraphAnswer createSelectedAnswer(@NotNull LinearGraph linearGraph, @NotNull Collection<Integer> selectedNodeIndexes) {
        HashSet selectedIds = ContainerUtil.newHashSet();
        for (Integer nodeIndex : selectedNodeIndexes) {
            if (nodeIndex == null) continue;
            selectedIds.add(linearGraph.getNodeId(nodeIndex));
        }
        return new LinearGraphController.LinearGraphAnswer(LinearGraphUtils.getCursor(true), selectedIds);
    }

    @Nullable
    public static GraphEdge getEdge(@NotNull LinearGraph graph2, int up, int down) {
        List<GraphEdge> edges = graph2.getAdjacentEdges(up, EdgeFilter.NORMAL_DOWN);
        for (GraphEdge edge : edges) {
            if (!LinearGraphUtils.intEqual(edge.getDownNodeIndex(), down)) continue;
            return edge;
        }
        return null;
    }

    @NotNull
    public static Set<Integer> convertNodeIndexesToIds(@NotNull LinearGraph graph2, @NotNull Collection<Integer> nodeIndexes) {
        return ContainerUtil.map2Set(nodeIndexes, nodeIndex -> graph2.getNodeId((int)nodeIndex));
    }

    @NotNull
    public static Set<Integer> convertIdsToNodeIndexes(@NotNull LinearGraph graph2, @NotNull Collection<Integer> ids) {
        List result2 = ContainerUtil.mapNotNull(ids, id -> graph2.getNodeIndex((int)id));
        return ContainerUtil.newHashSet((Iterable)result2);
    }
}

