/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.frame.DetailsPanel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryPanel
extends JPanel
implements DataProvider,
Disposable {
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final DetailsPanel myDetailsPanel;
    @NotNull
    private final JBSplitter myDetailsSplitter;
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final FileHistoryUi myUi;
    @NotNull
    private final VirtualFile myRoot;

    public FileHistoryPanel(@NotNull FileHistoryUi ui, final @NotNull VcsLogData logData, @NotNull VisiblePack visiblePack, @NotNull FilePath filePath) {
        this.myUi = ui;
        this.myFilePath = filePath;
        this.myRoot = (VirtualFile)ObjectUtils.notNull((Object)VcsLogUtil.getActualRoot(logData.getProject(), this.myFilePath));
        this.myGraphTable = new VcsLogGraphTable(this.myUi, logData, visiblePack, this.myUi::requestMore){

            @Override
            protected boolean isSpeedSearchEnabled() {
                return true;
            }

            @Override
            protected void updateEmptyText() {
                this.getEmptyText().setText("File history");
            }
        };
        this.myGraphTable.setCompactReferencesView(true);
        this.myGraphTable.setShowTagNames(false);
        this.myDetailsPanel = new DetailsPanel(logData, this.myUi.getColorManager(), this){

            @Override
            protected void navigate(@NotNull CommitId commit2) {
                VcsLogUiImpl mainLogUi = VcsProjectLog.getInstance(logData.getProject()).getMainLogUi();
                if (mainLogUi != null) {
                    mainLogUi.jumpToCommit(commit2.getHash(), commit2.getRoot());
                    VcsLogContentUtil.selectLogUi(logData.getProject(), mainLogUi);
                }
            }
        };
        this.myDetailsPanel.setBorder(IdeBorderFactory.createBorder((int)1));
        this.myDetailsSplitter = new OnePixelSplitter(true, "vcs.log.history.details.splitter.proportion", 0.7f);
        JComponent tableWithProgress = VcsLogUiUtil.installProgress(VcsLogUiUtil.setupScrolledGraph(this.myGraphTable, 1), logData, ui.getId(), this);
        this.myDetailsSplitter.setFirstComponent(tableWithProgress);
        this.myDetailsSplitter.setSecondComponent((JComponent)(this.myUi.getProperties().get(CommonUiProperties.SHOW_DETAILS) != false ? this.myDetailsPanel : null));
        this.myDetailsPanel.installCommitSelectionListener(this.myGraphTable);
        VcsLogUiUtil.installDetailsListeners(this.myGraphTable, this.myDetailsPanel, logData, this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myDetailsSplitter, "Center");
        this.add((Component)this.createActionsToolbar(), "West");
        PopupHandler.installPopupHandler((JComponent)((Object)this.myGraphTable), (String)"Vcs.FileHistory.ContextMenu", (String)"Vcs.FileHistory.ContextMenu");
        this.invokeOnDoubleClick(ActionManager.getInstance().getAction("Diff.ShowDiff"), tableWithProgress);
        Disposer.register((Disposable)this.myUi, (Disposable)this);
    }

    private void invokeOnDoubleClick(@NotNull AnAction action, @NotNull JComponent component) {
        new EmptyAction.MyDelegatingAction(action){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e.getInputEvent() instanceof MouseEvent && FileHistoryPanel.this.myGraphTable.isResizingColumns()) {
                    return;
                }
                super.actionPerformed(e);
            }
        }.registerCustomShortcutSet(CommonShortcuts.DOUBLE_CLICK_1, component);
    }

    @NotNull
    private JComponent createActionsToolbar() {
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add(ActionManager.getInstance().getAction("Vcs.FileHistory.Toolbar"));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("Vcs.FileHistory.Toolbar", (ActionGroup)toolbarGroup, false);
        toolbar.setTargetComponent((JComponent)((Object)this.myGraphTable));
        return toolbar.getComponent();
    }

    @NotNull
    public VcsLogGraphTable getGraphTable() {
        return this.myGraphTable;
    }

    public void updateDataPack(@NotNull VisiblePack visiblePack, boolean permanentGraphChanged) {
        this.myGraphTable.updateDataPack(visiblePack, permanentGraphChanged);
    }

    public void showDetails(boolean show) {
        this.myDetailsSplitter.setSecondComponent((JComponent)(show ? this.myDetailsPanel : null));
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (VcsDataKeys.CHANGES.is(dataId) || VcsDataKeys.SELECTED_CHANGES.is(dataId)) {
            Change change = this.myUi.getSelectedChange();
            if (change != null) {
                return new Change[]{change};
            }
            List details = this.myUi.getVcsLog().getSelectedDetails();
            if (details.isEmpty() || details.size() > 1000) {
                return null;
            }
            if (VcsLogUtil.getMaxSize(details) > VcsLogUtil.getShownChangesLimit()) {
                return null;
            }
            return VcsLogUtil.collectChanges(details, (Function<? super VcsFullCommitDetails, ? extends Collection<Change>>)((Function)detail -> this.myUi.collectRelevantChanges((VcsFullCommitDetails)detail))).toArray(new Change[0]);
        }
        if (VcsLogInternalDataKeys.LOG_UI_PROPERTIES.is(dataId)) {
            return this.myUi.getProperties();
        }
        if (VcsDataKeys.VCS_FILE_REVISION.is(dataId)) {
            List details = this.myUi.getVcsLog().getSelectedShortDetails();
            if (details.isEmpty()) {
                return null;
            }
            return this.myUi.createRevision((VcsCommitMetadata)ContainerUtil.getFirstItem((List)details));
        }
        if (VcsDataKeys.VCS_FILE_REVISIONS.is(dataId)) {
            List details = this.myUi.getVcsLog().getSelectedShortDetails();
            if (details.isEmpty() || details.size() > 1000) {
                return null;
            }
            return ContainerUtil.mapNotNull((Collection)details, this.myUi::createRevision).toArray(new VcsFileRevision[0]);
        }
        if (VcsDataKeys.FILE_PATH.is(dataId)) {
            return this.myFilePath;
        }
        if (VcsDataKeys.VCS_VIRTUAL_FILE.is(dataId)) {
            List details = this.myUi.getVcsLog().getSelectedShortDetails();
            if (details.isEmpty()) {
                return null;
            }
            VcsCommitMetadata detail2 = (VcsCommitMetadata)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)details));
            VirtualFile revision = FileHistoryUtil.createVcsVirtualFile(this.myUi.createRevision(detail2));
            if (revision != null) {
                return revision;
            }
        } else {
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                return this.myFilePath.getVirtualFile();
            }
            if (VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION.is(dataId)) {
                return false;
            }
            if (VcsLogInternalDataKeys.LOG_DIFF_HANDLER.is(dataId)) {
                return this.myUi.getLogData().getLogProvider(this.myRoot).getDiffHandler();
            }
        }
        return null;
    }

    public void dispose() {
        this.myDetailsSplitter.dispose();
    }
}

