/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.navigation.History;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.history.FileHistoryDiffPreview;
import com.intellij.vcs.log.history.FileHistoryFilterUi;
import com.intellij.vcs.log.history.FileHistoryPanel;
import com.intellij.vcs.log.history.FileHistoryUiProperties;
import com.intellij.vcs.log.history.FileHistoryUtil;
import com.intellij.vcs.log.history.FileHistoryVisiblePack;
import com.intellij.vcs.log.history.VcsLogFileRevision;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionListener;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryUi
extends AbstractVcsLogUi {
    @NotNull
    private static final String HELP_ID = "reference.versionControl.toolwindow.history";
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final VirtualFile myRoot;
    @Nullable
    private final Hash myRevision;
    @NotNull
    private final VcsLogDiffHandler myDiffHandler;
    @NotNull
    private final FileHistoryUiProperties myUiProperties;
    @NotNull
    private final FileHistoryFilterUi myFilterUi;
    @NotNull
    private final FileHistoryPanel myFileHistoryPanel;
    @Nullable
    private final FileHistoryDiffPreview myDiffPreview;
    @Nullable
    private final OnePixelSplitter myDiffPreviewSplitter;
    @NotNull
    private final JComponent myMainComponent;
    @NotNull
    private final Set<String> myHighlighterIds;
    @NotNull
    private final MyPropertiesChangeListener myPropertiesChangeListener;
    @NotNull
    private final History myHistory;

    public FileHistoryUi(@NotNull VcsLogData logData, @NotNull VcsLogColorManager manager, @NotNull FileHistoryUiProperties uiProperties, @NotNull VisiblePackRefresher refresher, @NotNull FilePath path, @Nullable Hash revision, @NotNull VirtualFile root) {
        super(FileHistoryUi.getFileHistoryLogId(path, revision), logData, manager, refresher);
        this.myPath = path;
        this.myRoot = root;
        this.myRevision = revision;
        this.myUiProperties = uiProperties;
        this.myDiffHandler = (VcsLogDiffHandler)ObjectUtils.notNull((Object)logData.getLogProvider(root).getDiffHandler());
        this.myFilterUi = new FileHistoryFilterUi(path, revision, root, uiProperties);
        this.myFileHistoryPanel = new FileHistoryPanel(this, logData, this.myVisiblePack, path);
        if (!this.myPath.isDirectory()) {
            this.myDiffPreview = new FileHistoryDiffPreview(this.myProject, (Function0<? extends Change>)((Function0)() -> this.getSelectedChange()), this);
            ListSelectionListener selectionListener = e -> {
                int[] selection = this.getTable().getSelectedRows();
                ApplicationManager.getApplication().invokeLater(() -> this.myDiffPreview.updatePreview(this.myUiProperties.get(CommonUiProperties.SHOW_DIFF_PREVIEW)), o -> !Arrays.equals(selection, this.getTable().getSelectedRows()));
            };
            this.getTable().getSelectionModel().addListSelectionListener(selectionListener);
            this.myDiffPreviewSplitter = new OnePixelSplitter(false, "vcs.history.diff.splitter.proportion", 0.7f);
            this.myDiffPreviewSplitter.setHonorComponentsMinimumSize(false);
            this.myDiffPreviewSplitter.setFirstComponent((JComponent)this.myFileHistoryPanel);
            this.showDiffPreview(this.myUiProperties.get(CommonUiProperties.SHOW_DIFF_PREVIEW));
            this.myMainComponent = this.myDiffPreviewSplitter;
        } else {
            this.myDiffPreview = null;
            this.myDiffPreviewSplitter = null;
            this.myMainComponent = this.myFileHistoryPanel;
        }
        this.myHighlighterIds = this.myRevision == null ? ContainerUtil.newHashSet((Object[])new String[]{"MY_COMMITS", "CURRENT_BRANCH"}) : Collections.singleton("MY_COMMITS");
        for (VcsLogHighlighterFactory factory : ContainerUtil.filter((Object[])LOG_HIGHLIGHTER_FACTORY_EP.getExtensions((AreaInstance)this.myProject), f -> this.isHighlighterEnabled(f.getId()))) {
            this.getTable().addHighlighter(factory.createHighlighter(logData, this));
        }
        if (this.myRevision != null) {
            this.getTable().addHighlighter(new RevisionHistoryHighlighter(this.myLogData.getStorage(), this.myRevision, this.myRoot));
        }
        this.myPropertiesChangeListener = new MyPropertiesChangeListener();
        this.myUiProperties.addChangeListener(this.myPropertiesChangeListener);
        this.myHistory = VcsLogUiUtil.installNavigationHistory(this);
    }

    @NotNull
    public static String getFileHistoryLogId(@NotNull FilePath path, @Nullable Hash revision) {
        return path.getPath() + (revision == null ? "" : revision.asString());
    }

    public boolean hasDiffPreview() {
        return this.myDiffPreview != null;
    }

    @Nullable
    public VcsFileRevision createRevision(@Nullable VcsCommitMetadata commit2) {
        if (commit2 == null) {
            return null;
        }
        if (this.isFileDeletedInCommit((Hash)commit2.getId())) {
            return VcsFileRevision.NULL;
        }
        FilePath path = this.getPathInCommit((Hash)commit2.getId());
        if (path == null) {
            return null;
        }
        return new VcsLogFileRevision(commit2, this.myDiffHandler.createContentRevision(path, (Hash)commit2.getId()), path, false);
    }

    @Nullable
    public FilePath getPathInCommit(@NotNull Hash hash) {
        if (this.myPath.isDirectory()) {
            return this.myPath;
        }
        int commitIndex = this.myLogData.getStorage().getCommitIndex(hash, this.myRoot);
        return FileHistoryVisiblePack.filePath(this.myVisiblePack, commitIndex);
    }

    private boolean isFileDeletedInCommit(@NotNull Hash hash) {
        if (this.myPath.isDirectory()) {
            return false;
        }
        int commitIndex = this.myLogData.getStorage().getCommitIndex(hash, this.myRoot);
        return FileHistoryVisiblePack.isDeletedInCommit(this.myVisiblePack, commitIndex);
    }

    @NotNull
    List<Change> collectRelevantChanges(@NotNull VcsFullCommitDetails details) {
        FilePath filePath = this.getPathInCommit((Hash)details.getId());
        if (filePath == null) {
            return ContainerUtil.emptyList();
        }
        return FileHistoryUtil.collectRelevantChanges(details, (Condition<? super Change>)((Condition)change -> filePath.isDirectory() ? FileHistoryUtil.affectsDirectory(change, filePath) : FileHistoryUtil.affectsFile(change, filePath, this.isFileDeletedInCommit((Hash)details.getId()))));
    }

    @Nullable
    public Change getSelectedChange() {
        if (this.myPath.isDirectory()) {
            return null;
        }
        int[] rows = this.getTable().getSelectedRows();
        if (rows.length == 0) {
            return null;
        }
        int row2 = rows[0];
        List<Integer> parentRows = rows.length == 1 ? this.myVisiblePack.getVisibleGraph().getRowInfo(row2).getAdjacentRows(true) : Collections.singletonList(rows[rows.length - 1]);
        return FileHistoryUtil.createChangeToParents(row2, parentRows, this.myVisiblePack, this.myDiffHandler, this.myLogData);
    }

    @Override
    protected <T> void handleCommitNotFound(@NotNull T commitId, boolean commitExists, @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter) {
        if (!commitExists) {
            super.handleCommitNotFound(commitId, false, rowGetter);
            return;
        }
        String mainText = "Commit " + FileHistoryUi.getCommitPresentation(commitId) + " does not exist in history for " + this.myPath.getName();
        if (this.getFilterUi().getFilters().get(VcsLogFilterCollection.BRANCH_FILTER) != null) {
            this.showWarningWithLink(mainText + " in current branch", "View and Show All Branches", () -> {
                this.myUiProperties.set(FileHistoryUiProperties.SHOW_ALL_BRANCHES, true);
                this.invokeOnChange(() -> this.jumpTo(commitId, rowGetter, (SettableFuture<? super Boolean>)SettableFuture.create()));
            });
        } else {
            VcsLogUiImpl mainLogUi = VcsProjectLog.getInstance(this.myProject).getMainLogUi();
            if (mainLogUi != null) {
                this.showWarningWithLink(mainText, "View in Log", () -> {
                    if (VcsLogContentUtil.selectLogUi(this.myProject, mainLogUi)) {
                        if (commitId instanceof Hash) {
                            mainLogUi.jumpToCommit((Hash)commitId, this.myRoot, (SettableFuture<? super Boolean>)SettableFuture.create());
                        } else if (commitId instanceof String) {
                            mainLogUi.jumpToCommitByPartOfHash((String)commitId, (SettableFuture<? super Boolean>)SettableFuture.create());
                        }
                    }
                });
            }
        }
    }

    public boolean matches(@NotNull FilePath targetPath, @Nullable Hash targetRevision) {
        return this.myPath.equals(targetPath) && Objects.equals(this.myRevision, targetRevision);
    }

    private void showDiffPreview(boolean state) {
        if (this.myDiffPreview != null) {
            this.myDiffPreview.updatePreview(state);
            this.myDiffPreviewSplitter.setSecondComponent(state ? this.myDiffPreview.getComponent() : null);
        }
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        return this.myFilterUi;
    }

    public boolean isHighlighterEnabled(@NotNull String id) {
        return this.myHighlighterIds.contains(id);
    }

    @Override
    protected void onVisiblePackUpdated(boolean permGraphChanged) {
        this.myFileHistoryPanel.updateDataPack(this.myVisiblePack, permGraphChanged);
        if (this.myDiffPreview != null) {
            this.myDiffPreview.updatePreview(this.myUiProperties.get(CommonUiProperties.SHOW_DIFF_PREVIEW));
        }
    }

    @Override
    @NotNull
    public VcsLogGraphTable getTable() {
        return this.myFileHistoryPanel.getGraphTable();
    }

    @Override
    @NotNull
    public Component getMainComponent() {
        return this.myMainComponent;
    }

    @Override
    @Nullable
    public String getHelpId() {
        return HELP_ID;
    }

    private void updateFilter() {
        this.myRefresher.onFiltersChange(this.myFilterUi.getFilters());
    }

    @Override
    @NotNull
    public FileHistoryUiProperties getProperties() {
        return this.myUiProperties;
    }

    @Override
    @Nullable
    public History getNavigationHistory() {
        return this.myHistory;
    }

    @Override
    public void dispose() {
        this.myUiProperties.removeChangeListener(this.myPropertiesChangeListener);
        super.dispose();
    }

    private static class RevisionHistoryHighlighter
    implements VcsLogHighlighter {
        @NotNull
        private final JBColor myBgColor = JBColor.namedColor((String)"VersionControl.FileHistory.Commit.selectedBranchBackground", (Color)new JBColor(new Color(0xFFFEE4), new Color(4802879)));
        @NotNull
        private final VcsLogStorage myStorage;
        @NotNull
        private final Hash myRevision;
        @NotNull
        private final VirtualFile myRoot;
        @Nullable
        private Condition<Integer> myCondition;
        @NotNull
        private VcsLogDataPack myVisiblePack = VisiblePack.EMPTY;

        RevisionHistoryHighlighter(@NotNull VcsLogStorage storage2, @NotNull Hash revision, @NotNull VirtualFile root) {
            this.myStorage = storage2;
            this.myRevision = revision;
            this.myRoot = root;
        }

        @NotNull
        public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId, @NotNull VcsShortCommitDetails commitDetails, boolean isSelected) {
            if (isSelected) {
                return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            }
            if (this.myCondition == null) {
                this.myCondition = this.getCondition();
            }
            if (this.myCondition.value((Object)commitId)) {
                return VcsCommitStyleFactory.background((Color)this.myBgColor);
            }
            return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        }

        @NotNull
        private Condition<Integer> getCondition() {
            if (!(this.myVisiblePack instanceof VisiblePack)) {
                return Conditions.alwaysFalse();
            }
            DataPackBase dataPack = ((VisiblePack)this.myVisiblePack).getDataPack();
            if (!(dataPack instanceof DataPack)) {
                return Conditions.alwaysFalse();
            }
            Set<Integer> heads = Collections.singleton(this.myStorage.getCommitIndex(this.myRevision, this.myRoot));
            return ((DataPack)dataPack).getPermanentGraph().getContainedInBranchCondition(heads);
        }

        public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
            this.myVisiblePack = dataPack;
            this.myCondition = this.myVisiblePack.getFilters().get(VcsLogFilterCollection.REVISION_FILTER) != null ? Conditions.alwaysFalse() : null;
        }
    }

    private class MyPropertiesChangeListener
    implements VcsLogUiProperties.PropertiesChangeListener {
        private MyPropertiesChangeListener() {
        }

        @Override
        public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
                FileHistoryUi.this.myFileHistoryPanel.showDetails(FileHistoryUi.this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
            } else if (FileHistoryUiProperties.SHOW_ALL_BRANCHES.equals(property)) {
                FileHistoryUi.this.updateFilter();
            } else if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
                FileHistoryUi.this.getTable().onColumnOrderSettingChanged();
            } else if (property instanceof CommonUiProperties.TableColumnProperty) {
                FileHistoryUi.this.getTable().forceReLayout(((CommonUiProperties.TableColumnProperty)property).getColumn());
            } else if (CommonUiProperties.SHOW_DIFF_PREVIEW.equals(property)) {
                FileHistoryUi.this.showDiffPreview(FileHistoryUi.this.myUiProperties.get(CommonUiProperties.SHOW_DIFF_PREVIEW));
            }
        }
    }
}

