/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="Vcs.Log.History.Properties", storages={@Storage(value="$WORKSPACE_FILE$")})
public class FileHistoryUiProperties
implements VcsLogUiProperties,
PersistentStateComponent<State> {
    public static final VcsLogUiProperties.VcsLogUiProperty<Boolean> SHOW_ALL_BRANCHES = new VcsLogUiProperties.VcsLogUiProperty("Table.ShowOtherBranches");
    @NotNull
    private final Collection<VcsLogUiProperties.PropertiesChangeListener> myListeners = ContainerUtil.newLinkedHashSet();
    private State myState = new State();

    @Override
    @NotNull
    public <T> T get(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
        if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
            return (T)Boolean.valueOf(this.myState.SHOW_DETAILS);
        }
        if (SHOW_ALL_BRANCHES.equals(property)) {
            return (T)Boolean.valueOf(this.myState.SHOW_OTHER_BRANCHES);
        }
        if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
            ArrayList order = this.myState.COLUMN_ORDER;
            if (order == null || order.isEmpty()) {
                order = ContainerUtilRt.newArrayList((Object[])new Integer[]{0, 2, 3, 1});
            }
            return (T)order;
        }
        if (property instanceof CommonUiProperties.TableColumnProperty) {
            Integer savedWidth = this.myState.COLUMN_WIDTH.get(((CommonUiProperties.TableColumnProperty)property).getColumn());
            if (savedWidth == null) {
                return (T)Integer.valueOf(-1);
            }
            return (T)savedWidth;
        }
        if (CommonUiProperties.SHOW_DIFF_PREVIEW.equals(property)) {
            return (T)Boolean.valueOf(this.myState.SHOW_DIFF_PREVIEW);
        }
        throw new UnsupportedOperationException("Unknown property " + property);
    }

    @Override
    public <T> void set(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property, @NotNull T value) {
        if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
            this.myState.SHOW_DETAILS = (Boolean)value;
        } else if (SHOW_ALL_BRANCHES.equals(property)) {
            this.myState.SHOW_OTHER_BRANCHES = (Boolean)value;
        } else if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
            this.myState.COLUMN_ORDER = (List)value;
        } else if (property instanceof CommonUiProperties.TableColumnProperty) {
            this.myState.COLUMN_WIDTH.put(((CommonUiProperties.TableColumnProperty)property).getColumn(), (Integer)value);
        } else if (CommonUiProperties.SHOW_DIFF_PREVIEW.equals(property)) {
            this.myState.SHOW_DIFF_PREVIEW = (Boolean)value;
        } else {
            throw new UnsupportedOperationException("Unknown property " + property);
        }
        this.myListeners.forEach(l -> l.onPropertyChanged(property));
    }

    @Override
    public <T> boolean exists(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
        return CommonUiProperties.SHOW_DETAILS.equals(property) || SHOW_ALL_BRANCHES.equals(property) || CommonUiProperties.COLUMN_ORDER.equals(property) || CommonUiProperties.SHOW_DIFF_PREVIEW.equals(property) || property instanceof CommonUiProperties.TableColumnProperty;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
    }

    @Override
    public void addChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
        this.myListeners.add(listener2);
    }

    @Override
    public void removeChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
        this.myListeners.remove(listener2);
    }

    public static class State {
        public boolean SHOW_DETAILS = false;
        public boolean SHOW_OTHER_BRANCHES = false;
        public Map<Integer, Integer> COLUMN_WIDTH = ContainerUtil.newHashMap();
        public List<Integer> COLUMN_ORDER = ContainerUtil.newArrayList();
        public boolean SHOW_DIFF_PREVIEW = true;
    }
}

