/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryVisiblePack;
import com.intellij.vcs.log.impl.VcsChangesMerger;
import com.intellij.vcs.log.visible.VisiblePack;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryUtil {
    @Nullable
    public static VirtualFile createVcsVirtualFile(@Nullable VcsFileRevision revision) {
        if (!VcsHistoryUtil.isEmpty(revision) && revision instanceof VcsFileRevisionEx) {
            FilePath path = ((VcsFileRevisionEx)revision).getPath();
            return path.isDirectory() ? new VcsVirtualFolder(path.getPath(), null, (VirtualFileSystem)VcsFileSystem.getInstance()) : new VcsVirtualFile(path.getPath(), revision, (VirtualFileSystem)VcsFileSystem.getInstance());
        }
        return null;
    }

    @NotNull
    public static List<Change> collectRelevantChanges(@NotNull VcsFullCommitDetails details, @NotNull Condition<? super Change> isRelevant) {
        List changes2 = ContainerUtil.filter((Collection)details.getChanges(), isRelevant);
        if (!changes2.isEmpty()) {
            return changes2;
        }
        if (details.getParents().size() > 1) {
            for (int parent = 0; parent < details.getParents().size(); ++parent) {
                List changesToParent = ContainerUtil.filter((Collection)details.getChanges(parent), isRelevant);
                if (changesToParent.isEmpty()) continue;
                return changesToParent;
            }
        }
        return Collections.emptyList();
    }

    public static boolean affectsFile(@NotNull Change change, @NotNull FilePath file2, boolean isDeleted) {
        ContentRevision revision;
        ContentRevision contentRevision = revision = isDeleted ? change.getBeforeRevision() : change.getAfterRevision();
        if (revision == null) {
            return false;
        }
        return file2.equals(revision.getFile());
    }

    public static boolean affectsDirectory(@NotNull Change change, @NotNull FilePath directory) {
        FilePath file2 = ((ContentRevision)ObjectUtils.notNull((Object)ObjectUtils.chooseNotNull((Object)change.getAfterRevision(), (Object)change.getBeforeRevision()))).getFile();
        return VfsUtilCore.isAncestor((File)directory.getIOFile(), (File)file2.getIOFile(), (boolean)false);
    }

    @Nullable
    static Change createChangeToParents(int commitRow, @NotNull List<Integer> parentRows, @NotNull VisiblePack visiblePack, @NotNull VcsLogDiffHandler diffHandler, @NotNull VcsLogData logData) {
        int commitIndex = (Integer)visiblePack.getVisibleGraph().getRowInfo(commitRow).getCommit();
        FilePath path = FileHistoryVisiblePack.filePath(visiblePack, commitIndex);
        if (path == null) {
            return null;
        }
        Hash commitHash = logData.getCommitId(commitIndex).getHash();
        ContentRevision afterRevision = FileHistoryUtil.createContentRevision(commitHash, commitIndex, visiblePack, diffHandler);
        List<Object> parentCommits = ContainerUtil.map(parentRows, r -> (Integer)visiblePack.getVisibleGraph().getRowInfo(r.intValue()).getCommit());
        if (parentCommits.isEmpty() && commitRow + 1 < visiblePack.getVisibleGraph().getVisibleCommitCount()) {
            parentCommits = Collections.singletonList(visiblePack.getVisibleGraph().getRowInfo(commitRow + 1).getCommit());
        }
        if (parentCommits.isEmpty()) {
            if (afterRevision == null) {
                return null;
            }
            return new Change(null, afterRevision);
        }
        List parentHashes = ContainerUtil.map((Collection)parentCommits, c -> logData.getCommitId((int)c).getHash());
        List parentChanges = ContainerUtil.mapNotNull((Collection)ContainerUtil.toCollection((Iterable)ContainerUtil.zip((Iterable)parentCommits, (Iterable)parentHashes)), parent -> {
            ContentRevision beforeRevision = FileHistoryUtil.createContentRevision((Hash)parent.second, (Integer)parent.first, visiblePack, diffHandler);
            if (afterRevision == null && beforeRevision == null) {
                return null;
            }
            return new Change(beforeRevision, afterRevision);
        });
        if (parentChanges.size() <= 1) {
            return (Change)ContainerUtil.getFirstItem((List)parentChanges);
        }
        return new MyVcsChangesMerger(commitHash, parentHashes, diffHandler).merge(path, parentChanges);
    }

    @Nullable
    private static ContentRevision createContentRevision(@NotNull Hash commitHash, int commitIndex, @NotNull VcsLogDataPack visiblePack, @NotNull VcsLogDiffHandler diffHandler) {
        boolean isDeleted = FileHistoryVisiblePack.isDeletedInCommit(visiblePack, commitIndex);
        if (isDeleted) {
            return null;
        }
        FilePath path = FileHistoryVisiblePack.filePath(visiblePack, commitIndex);
        if (path == null) {
            return null;
        }
        return diffHandler.createContentRevision(path, commitHash);
    }

    private static class MyVcsChangesMerger
    extends VcsChangesMerger {
        @NotNull
        private final Hash myCommit;
        @NotNull
        private final Hash myFirstParent;
        @NotNull
        private final VcsLogDiffHandler myDiffHandler;

        private MyVcsChangesMerger(@NotNull Hash commit2, @NotNull List<Hash> parentCommits, @NotNull VcsLogDiffHandler diffHandler) {
            this.myCommit = commit2;
            this.myFirstParent = (Hash)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(parentCommits));
            this.myDiffHandler = diffHandler;
        }

        @Override
        @NotNull
        protected Change createChange(@NotNull Change.Type type, @Nullable FilePath beforePath, @Nullable FilePath afterPath) {
            ContentRevision beforeRevision = beforePath == null ? null : this.myDiffHandler.createContentRevision(beforePath, this.myFirstParent);
            ContentRevision afterRevision = afterPath == null ? null : this.myDiffHandler.createContentRevision(afterPath, this.myCommit);
            return new Change(beforeRevision, afterRevision);
        }
    }
}

