/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUiFactory;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFileHistoryProviderImpl
implements VcsLogFileHistoryProvider {
    @NotNull
    public static final String TAB_NAME = "History";

    public boolean canShowFileHistory(@NotNull Project project, @NotNull FilePath path) {
        if (!Registry.is((String)"vcs.new.history")) {
            return false;
        }
        VirtualFile root = VcsLogUtil.getActualRoot(project, path);
        if (root == null) {
            return false;
        }
        VcsLogData dataManager = VcsProjectLog.getInstance(project).getDataManager();
        if (dataManager == null) {
            return false;
        }
        return dataManager.getIndex().isIndexingEnabled(root);
    }

    public void showFileHistory(@NotNull Project project, @NotNull FilePath path, @Nullable String revisionNumber) {
        VirtualFile root = (VirtualFile)ObjectUtils.assertNotNull((Object)VcsLogUtil.getActualRoot(project, path));
        FilePath correctedPath = VcsLogFileHistoryProviderImpl.getCorrectedPath(project, path, root, revisionNumber);
        Hash hash = revisionNumber != null ? HashImpl.build(revisionNumber) : null;
        VcsLogManager logManager = (VcsLogManager)ObjectUtils.assertNotNull((Object)VcsProjectLog.getInstance(project).getLogManager());
        BiConsumer<AbstractVcsLogUi, Boolean> historyUiConsumer = (ui, firstTime) -> {
            if (hash != null) {
                ui.jumpToNearestCommit(hash, root);
            } else if (firstTime.booleanValue()) {
                ui.jumpToRow(0);
            }
        };
        if (path.isDirectory() && VcsLogUtil.isFolderHistoryShownInLog()) {
            VcsLogFileHistoryProviderImpl.findOrOpenFolderHistory(project, logManager, root, correctedPath, hash, historyUiConsumer);
        } else {
            VcsLogFileHistoryProviderImpl.findOrOpenHistory(project, logManager, root, correctedPath, hash, historyUiConsumer);
        }
    }

    private static void findOrOpenHistory(@NotNull Project project, @NotNull VcsLogManager logManager, @NotNull VirtualFile root, @NotNull FilePath path, @Nullable Hash hash, @NotNull BiConsumer<AbstractVcsLogUi, Boolean> consumer) {
        boolean firstTime;
        FileHistoryUi fileHistoryUi = VcsLogContentUtil.findAndSelect(project, FileHistoryUi.class, ui -> ui.matches(path, hash));
        boolean bl = firstTime = fileHistoryUi == null;
        if (firstTime) {
            String suffix = hash != null ? " (" + hash.toShortString() + ")" : "";
            fileHistoryUi = VcsLogContentUtil.openLogTab(project, logManager, TAB_NAME, path.getName() + suffix, new FileHistoryUiFactory(path, root, hash), true);
        }
        consumer.accept(fileHistoryUi, firstTime);
    }

    private static void findOrOpenFolderHistory(@NotNull Project project, @NotNull VcsLogManager logManager, @NotNull VirtualFile root, @NotNull FilePath path, @Nullable Hash hash, @NotNull BiConsumer<AbstractVcsLogUi, Boolean> consumer) {
        boolean firstTime;
        VcsLogUiImpl ui = VcsLogContentUtil.findAndSelect(project, VcsLogUiImpl.class, logUi -> VcsLogFileHistoryProviderImpl.matches(logUi.getFilterUi().getFilters(), path, hash));
        boolean bl = firstTime = ui == null;
        if (firstTime) {
            VcsLogFilterCollection filters = VcsLogFileHistoryProviderImpl.createFilters(path, hash, root);
            ui = VcsProjectLog.getInstance(project).getTabsManager().openAnotherLogTab(logManager, filters);
            ui.getProperties().set(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES, true);
        }
        consumer.accept(ui, firstTime);
    }

    @NotNull
    private static VcsLogFilterCollection createFilters(@NotNull FilePath filePath, @Nullable Hash hash, @NotNull VirtualFile root) {
        Object pathFilter = Objects.equals(filePath.getVirtualFile(), root) ? VcsLogFilterObject.fromRoot(root) : VcsLogFilterObject.fromPaths(Collections.singleton(filePath));
        if (hash == null) {
            return VcsLogFilterObject.collection(new VcsLogFilter[]{pathFilter, VcsLogFilterObject.fromBranch("HEAD")});
        }
        return VcsLogFilterObject.collection(new VcsLogFilter[]{pathFilter, VcsLogFilterObject.fromCommit(new CommitId(hash, root))});
    }

    private static boolean matches(@NotNull VcsLogFilterCollection filters, @NotNull FilePath filePath, @Nullable Hash hash) {
        VcsLogFilterCollection.FilterKey hashKey;
        VcsLogFilterCollection.FilterKey filterKey = hashKey = hash == null ? VcsLogFilterCollection.BRANCH_FILTER : VcsLogFilterCollection.REVISION_FILTER;
        if (!VcsLogFiltersKt.matches(filters, hashKey, VcsLogFilterCollection.STRUCTURE_FILTER) && !VcsLogFiltersKt.matches(filters, hashKey, VcsLogFilterCollection.ROOT_FILTER)) {
            return false;
        }
        if (!Objects.equals(VcsLogFileHistoryProviderImpl.getSingleFilePath(filters), filePath)) {
            return false;
        }
        if (hash != null) {
            return Objects.equals(VcsLogFileHistoryProviderImpl.getSingleHash(filters), hash);
        }
        return VcsLogFileHistoryProviderImpl.isFilteredByHead(filters);
    }

    private static boolean isFilteredByHead(@NotNull VcsLogFilterCollection filters) {
        VcsLogBranchFilter branchFilter = (VcsLogBranchFilter)filters.get(VcsLogFilterCollection.BRANCH_FILTER);
        if (branchFilter == null) {
            return false;
        }
        return branchFilter.getTextPresentation().equals(Collections.singletonList("HEAD"));
    }

    @Nullable
    private static Hash getSingleHash(@NotNull VcsLogFilterCollection filters) {
        VcsLogRevisionFilter revisionFilter = (VcsLogRevisionFilter)filters.get(VcsLogFilterCollection.REVISION_FILTER);
        if (revisionFilter == null) {
            return null;
        }
        Collection heads = revisionFilter.getHeads();
        if (heads.size() != 1) {
            return null;
        }
        return ((CommitId)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)heads))).getHash();
    }

    @Nullable
    private static FilePath getSingleFilePath(@NotNull VcsLogFilterCollection filters) {
        VcsLogStructureFilter structureFilter = (VcsLogStructureFilter)filters.get(VcsLogFilterCollection.STRUCTURE_FILTER);
        if (structureFilter == null) {
            VcsLogRootFilter rootFilter = (VcsLogRootFilter)filters.get(VcsLogFilterCollection.ROOT_FILTER);
            if (rootFilter == null) {
                return null;
            }
            Collection roots = rootFilter.getRoots();
            if (roots.size() != 1) {
                return null;
            }
            return VcsUtil.getFilePath((VirtualFile)((VirtualFile)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)roots))));
        }
        Collection filePaths = structureFilter.getFiles();
        if (filePaths.size() != 1) {
            return null;
        }
        return (FilePath)ContainerUtil.getFirstItem((Collection)filePaths);
    }

    @NotNull
    private static FilePath getCorrectedPath(@NotNull Project project, @NotNull FilePath path, @NotNull VirtualFile root, @Nullable String revisionNumber) {
        if (!root.equals(VcsUtil.getVcsRootFor((Project)project, (FilePath)path)) && path.isDirectory()) {
            path = VcsUtil.getFilePath((String)path.getPath(), (boolean)false);
        }
        if (revisionNumber == null) {
            return VcsUtil.getLastCommitPath((Project)project, (FilePath)path);
        }
        return path;
    }
}

